/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.Message;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.OptionEnum;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final LinkedHashMap<String, EntryInfo> entries = new LinkedHashMap();
    private static boolean reloadScreen = false;
    public static final Map<String, Class<? extends MidnightConfig>> configClass = new HashMap<String, Class<? extends MidnightConfig>>();
    private static Path path;
    private static final Gson gson;

    public static void loadValuesFromJson(String modid) {
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(modid));
        }
        catch (Exception e) {
            MidnightConfig.write(modid);
        }
        entries.values().forEach(info -> {
            if (info.field != null && info.entry != null) {
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.toTemporaryValue();
                    info.updateConditions();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        });
    }

    public static void init(String modid, Class<? extends MidnightConfig> config) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo(field, modid);
            if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && PlatformFunctions.isClientEnv()) {
                MidnightConfig.initClient(modid, field, info);
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        MidnightConfig.loadValuesFromJson(modid);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void initClient(String modid, Field field, EntryInfo info) {
        Entry e = info.entry;
        String key = modid + ":" + field.getName();
        if (e != null) {
            if (info.dataType == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == ResourceLocation.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.translatable((String)((Boolean)value != false ? "gui.yes" : "gui.no")).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> MidnightConfig.getEnumTranslatableText(value, modid, info);
                info.function = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.setValue(values.get(index >= values.size() ? 0 : index));
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            }
        }
        entries.put(key, info);
    }

    public static Class<?> getUnderlyingType(Field field) {
        Class rawType = field.getType();
        if (field.getType() == List.class) {
            rawType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        try {
            return (Class)rawType.getField("TYPE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return rawType;
        }
    }

    private static Component getEnumTranslatableText(Object value, String modid, EntryInfo info) {
        if (value instanceof OptionEnum) {
            OptionEnum translatableOption = (OptionEnum)value;
            return translatableOption.getCaption();
        }
        String translationKey = "%s.midnightconfig.enum.%s.%s".formatted(modid, info.dataType.getSimpleName(), info.toTemporaryValue());
        return I18n.exists((String)translationKey) ? Component.translatable((String)translationKey) : Component.literal((String)info.toTemporaryValue());
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches() || info.dataType == ResourceLocation.class && ResourceLocation.read((String)s).isError()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : Component.literal((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).withStyle(ChatFormatting.RED);
                t.setTooltip(info.getTooltip(true));
            }
            info.tempValue = s;
            t.setTextColor(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.active = entries.values().stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == ResourceLocation.class) {
                    info.setValue(ResourceLocation.tryParse((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.entry.isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static MidnightConfig getClass(String modid) {
        try {
            return configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String modid) {
        MidnightConfig.getClass(modid).writeChanges(modid);
    }

    public void writeChanges(String modid) {
        try {
            path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)MidnightConfig.getClass(modid)).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        String key = modid + ":" + entry;
        return entries.containsKey(key) ? MidnightConfig.entries.get((Object)key).defaultValue : null;
    }

    public void onTabInit(String tabName, MidnightConfigListWidget list, MidnightConfigScreen screen) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Screen getScreen(Screen parent, String modid) {
        return new MidnightConfigScreen(parent, modid);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new NonEntryExclusionStrategy()).registerTypeAdapter(ResourceLocation.class, (Object)new TypeAdapter<ResourceLocation>(){

            public void write(JsonWriter out, ResourceLocation id) throws IOException {
                out.value(id.toString());
            }

            public ResourceLocation read(JsonReader in) throws IOException {
                return ResourceLocation.parse((String)in.nextString());
            }
        }).setPrettyPrinting().create();
    }

    public static class EntryInfo {
        public Entry entry;
        public Comment comment;
        public Condition[] conditions;
        public final Field field;
        public final Class<?> dataType;
        public final String modid;
        public final String fieldName;
        int listIndex;
        Object defaultValue;
        Object value;
        Object function;
        String tempValue;
        boolean inLimits = true;
        Component name;
        Component error;
        AbstractWidget actionButton;
        Tab tab;
        boolean conditionsMet = true;

        public EntryInfo(Field field, String modid) {
            this.field = field;
            this.modid = modid;
            if (field != null) {
                this.fieldName = field.getName();
                this.dataType = MidnightConfig.getUnderlyingType(field);
                this.entry = field.getAnnotation(Entry.class);
                this.comment = field.getAnnotation(Comment.class);
                this.conditions = (Condition[])field.getAnnotationsByType(Condition.class);
            } else {
                this.fieldName = "";
                this.dataType = null;
            }
            if (this.entry != null && !this.entry.name().isEmpty()) {
                this.name = Component.translatable((String)this.entry.name());
            } else if (this.comment != null && !this.comment.name().isEmpty()) {
                this.name = Component.translatable((String)this.comment.name());
            }
        }

        public void setValue(Object value) {
            if (this.field.getType() != List.class) {
                this.value = value;
                this.tempValue = value.toString();
            } else {
                this.writeList(this.listIndex, value);
                this.tempValue = this.toTemporaryValue();
            }
        }

        public String toTemporaryValue() {
            if (this.field.getType() != List.class) {
                return this.value.toString();
            }
            try {
                return ((List)this.value).get(this.listIndex).toString();
            }
            catch (Exception ignored) {
                return "";
            }
        }

        public void updateFieldValue() {
            try {
                if (this.field.get(null) != this.value) {
                    entries.values().forEach(EntryInfo::updateConditions);
                }
                this.field.set(null, this.value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public void updateConditions() {
            boolean prevConditionState = this.conditionsMet;
            if (this.conditions.length > 0) {
                this.conditionsMet = true;
            }
            for (Condition condition : this.conditions) {
                String requiredOption;
                EntryInfo entryInfo;
                if (!condition.requiredModId().isEmpty() && !PlatformFunctions.isModLoaded(condition.requiredModId())) {
                    this.conditionsMet = false;
                }
                if ((entryInfo = entries.get(requiredOption = condition.requiredOption().contains(":") ? condition.requiredOption() : this.modid + ":" + condition.requiredOption())) instanceof EntryInfo) {
                    EntryInfo info = entryInfo;
                    this.conditionsMet &= List.of(condition.requiredValue()).contains(info.tempValue);
                }
                if (!this.conditionsMet) break;
            }
            if (prevConditionState != this.conditionsMet) {
                reloadScreen = true;
            }
        }

        public <T> void writeList(int index, T value) {
            List list = (List)this.value;
            if (index >= list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
        }

        public Tooltip getTooltip(boolean isButton) {
            String key = this.modid + ".midnightconfig." + this.fieldName + (!isButton ? ".label" : "") + ".tooltip";
            return Tooltip.create((Component)(isButton && this.error != null ? this.error : (I18n.exists((String)key) ? Component.translatable((String)key) : Component.empty())));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";

        public String name() default "";

        public String url() default "";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final String modid;
        public final Screen parent;
        public MidnightConfigListWidget list;
        public TabManager tabManager = new TabManager(a -> {}, a -> {});
        public Map<String, Tab> tabs = new LinkedHashMap<String, Tab>();
        public Tab prevTab;
        public TabNavigationBar tabNavigation;
        public Button done;
        public double scrollProgress = 0.0;

        protected MidnightConfigScreen(Screen parent, String modid) {
            super((Component)Component.translatable((String)(modid + ".midnightconfig.title")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".midnightconfig.";
            MidnightConfig.loadValuesFromJson(modid);
            entries.values().forEach(info -> {
                if (info.modid.equals(modid)) {
                    String tabId = info.entry != null ? info.entry.category() : info.comment.category();
                    String name = this.translationPrefix + "category." + tabId;
                    if (!I18n.exists((String)name) && tabId.equals("default")) {
                        name = this.translationPrefix + "title";
                    }
                    if (!this.tabs.containsKey(name)) {
                        GridLayoutTab tab = new GridLayoutTab((Component)Component.translatable((String)name));
                        info.tab = tab;
                        this.tabs.put(name, (Tab)tab);
                    } else {
                        info.tab = this.tabs.get(name);
                    }
                }
            });
            this.tabNavigation = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(this.tabs.values().toArray(new Tab[0])).build();
            this.tabNavigation.selectTab(0, false);
            this.tabNavigation.arrangeElements();
            this.prevTab = this.tabManager.getCurrentTab();
        }

        public void tick() {
            super.tick();
            if (this.prevTab != null && this.prevTab != this.tabManager.getCurrentTab()) {
                this.prevTab = this.tabManager.getCurrentTab();
                this.updateList();
                this.list.setScrollAmount(0.0);
            }
            this.scrollProgress = this.list.scrollAmount();
            for (EntryInfo info : entries.values()) {
                info.updateFieldValue();
            }
            this.updateButtons();
            if (reloadScreen) {
                this.updateList();
                reloadScreen = false;
            }
        }

        public void updateButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget widget;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || entry.info.field == null) continue;
                    AbstractWidget abstractWidget = entry.buttons.get(0);
                    if (abstractWidget instanceof AbstractWidget && ((widget = abstractWidget).isFocused() || widget.isHovered())) {
                        widget.setTooltip(entry.info.getTooltip(true));
                    }
                    if (!((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.active = !Objects.equals(String.valueOf(entry.info.value), String.valueOf(entry.info.defaultValue)) && entry.info.conditionsMet;
                }
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.tabNavigation.keyPressed(keyCode)) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void onClose() {
            MidnightConfig.loadValuesFromJson(this.modid);
            this.cleanup();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }

        private void cleanup() {
            entries.values().forEach(info -> {
                info.error = null;
                info.value = null;
                info.tempValue = null;
                info.actionButton = null;
                info.listIndex = 0;
                info.tab = null;
                info.inLimits = true;
            });
        }

        public void init() {
            super.init();
            this.tabNavigation.setWidth(this.width);
            this.tabNavigation.arrangeElements();
            if (this.tabs.size() > 1) {
                this.addRenderableWidget((GuiEventListener)this.tabNavigation);
            }
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 154, this.height - 26, 150, 20).build());
            this.done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
                for (EntryInfo info : entries.values()) {
                    if (!info.modid.equals(this.modid)) continue;
                    info.updateFieldValue();
                }
                MidnightConfig.write(this.modid);
                this.cleanup();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).bounds(this.width / 2 + 4, this.height - 26, 150, 20).build());
            this.list = new MidnightConfigListWidget(this.minecraft, this.width, this.height - 57, 24, 25);
            this.addWidget((GuiEventListener)this.list);
            this.fillList();
            if (this.tabs.size() > 1) {
                this.list.renderHeaderSeparator = false;
            }
        }

        public void updateList() {
            this.list.clear();
            this.fillList();
        }

        public void fillList() {
            String string;
            MidnightConfig midnightConfig = MidnightConfig.getClass(this.modid);
            ComponentContents componentContents = this.prevTab.getTabTitle().getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)componentContents;
                string = translatable.getKey().replace("%s.midnightconfig.category.".formatted(this.modid), "");
            } else {
                string = this.prevTab.getTabTitle().toString();
            }
            midnightConfig.onTabInit(string, this.list, this);
            for (EntryInfo info : entries.values()) {
                info.updateConditions();
                if (!info.conditionsMet) {
                    boolean visibleButLocked = false;
                    for (Condition condition : info.conditions) {
                        visibleButLocked |= condition.visibleButLocked();
                    }
                    if (!visibleButLocked) continue;
                }
                if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.getCurrentTab())) {
                    Component name = Objects.requireNonNullElseGet(info.name, () -> Component.translatable((String)(this.translationPrefix + info.fieldName)));
                    SpriteIconButton resetButton = SpriteIconButton.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                        info.value = info.defaultValue;
                        info.listIndex = 0;
                        info.tempValue = info.toTemporaryValue();
                        this.updateList();
                    }, (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/reset"), 12, 12).size(20, 20).build();
                    resetButton.setPosition(this.width - 205 + 150 + 25, 0);
                    if (info.function != null) {
                        Object widget;
                        Entry e = info.entry;
                        if (info.function instanceof Map.Entry) {
                            Map.Entry values = (Map.Entry)info.function;
                            if (info.dataType.isEnum()) {
                                values.setValue(value -> MidnightConfig.getEnumTranslatableText(value, this.modid, info));
                            }
                            widget = Button.builder((Component)((Component)((Function)values.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)values.getKey())).bounds(this.width - 185, 0, 150, 20).tooltip(info.getTooltip(true)).build();
                        } else {
                            widget = e.isSlider() ? new MidnightSliderWidget(this.width - 185, 0, 150, 20, Component.nullToEmpty((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.font, this.width - 185, 0, 150, 20, (Component)Component.empty());
                        }
                        if (widget instanceof EditBox) {
                            EditBox textField = widget;
                            textField.setMaxLength(e.width());
                            textField.setValue(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                            textField.setFilter(processor);
                        }
                        widget.setTooltip(info.getTooltip(true));
                        Button cycleButton = null;
                        if (info.field.getType() == List.class) {
                            cycleButton = Button.builder((Component)Component.literal((String)String.valueOf(info.listIndex)).withStyle(ChatFormatting.GOLD), button -> {
                                List values = (List)info.value;
                                values.remove("");
                                ++info.listIndex;
                                if (info.listIndex > values.size()) {
                                    info.listIndex = 0;
                                }
                                info.tempValue = info.toTemporaryValue();
                                if (info.listIndex == values.size()) {
                                    info.tempValue = "";
                                }
                                this.updateList();
                            }).bounds(this.width - 185, 0, 20, 20).build();
                        }
                        if (e.isColor()) {
                            Button colorButton = Button.builder((Component)Component.literal((String)"\u2b1b"), button -> new Thread(() -> {
                                Color newColor = JColorChooser.showDialog(null, Component.translatable((String)"midnightconfig.colorChooser.title").getString(), Color.decode(!Objects.equals(info.tempValue, "") ? info.tempValue : "#FFFFFF"));
                                if (newColor != null) {
                                    info.setValue("#" + Integer.toHexString(newColor.getRGB()).substring(2));
                                    this.updateList();
                                }
                            }).start()).bounds(this.width - 185, 0, 20, 20).build();
                            try {
                                colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.actionButton = colorButton;
                        } else if (e.selectionMode() > -1) {
                            SpriteIconButton explorerButton = SpriteIconButton.builder((Component)Component.empty(), button -> new Thread(() -> {
                                JFileChooser fileChooser = new JFileChooser(info.tempValue);
                                fileChooser.setFileSelectionMode(e.selectionMode());
                                fileChooser.setDialogType(e.fileChooserType());
                                fileChooser.setDialogTitle(Component.translatable((String)(this.translationPrefix + info.fieldName + ".fileChooser")).getString());
                                if ((e.selectionMode() == 0 || e.selectionMode() == 2) && Arrays.stream(e.fileExtensions()).noneMatch("*"::equals)) {
                                    fileChooser.setFileFilter(new FileNameExtensionFilter(Component.translatable((String)(this.translationPrefix + info.fieldName + ".fileFilter")).getString(), e.fileExtensions()));
                                }
                                if (fileChooser.showDialog(null, null) == 0) {
                                    info.setValue(fileChooser.getSelectedFile().getAbsolutePath());
                                    this.updateList();
                                }
                            }).start(), (boolean)true).sprite(ResourceLocation.fromNamespaceAndPath((String)"midnightlib", (String)"icon/explorer"), 12, 12).size(20, 20).build();
                            explorerButton.setPosition(this.width - 185, 0);
                            info.actionButton = explorerButton;
                        }
                        ArrayList widgets = Lists.newArrayList((Object[])new AbstractWidget[]{widget, resetButton});
                        if (info.actionButton != null) {
                            if (Minecraft.ON_OSX) {
                                info.actionButton.active = false;
                            }
                            widget.setWidth(widget.getWidth() - 22);
                            widget.setX(widget.getX() + 22);
                            widgets.add(info.actionButton);
                        }
                        if (cycleButton != null) {
                            if (info.actionButton != null) {
                                info.actionButton.setX(info.actionButton.getX() + 22);
                            }
                            widget.setWidth(widget.getWidth() - 22);
                            widget.setX(widget.getX() + 22);
                            widgets.add(cycleButton);
                        }
                        if (!info.conditionsMet) {
                            widgets.forEach(w -> {
                                w.active = false;
                            });
                        }
                        this.list.addButton(widgets, name, info);
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.list.setScrollAmount(this.scrollProgress);
                this.updateButtons();
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            super.render(context, mouseX, mouseY, delta);
            this.list.render(context, mouseX, mouseY, delta);
            if (this.tabs.size() < 2) {
                context.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
            }
        }
    }

    public static class NonEntryExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Conditions {
        public Condition[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=Conditions.class)
    @Target(value={ElementType.FIELD})
    public static @interface Condition {
        public String requiredModId() default "";

        public String requiredOption() default "";

        public String[] requiredValue() default {"true"};

        public boolean visibleButLocked() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class MidnightSliderWidget
    extends AbstractSliderButton {
        private final EntryInfo info;
        private final Entry e;

        public MidnightSliderWidget(int x, int y, int width, int height, Component text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.entry;
            this.info = info;
        }

        public void updateMessage() {
            this.setMessage(Component.nullToEmpty((String)this.info.tempValue));
        }

        public void applyValue() {
            if (this.info.dataType == Integer.TYPE) {
                this.info.setValue(((Number)(this.e.min() + this.value * (this.e.max() - this.e.min()))).intValue());
            } else if (this.info.dataType == Double.TYPE) {
                this.info.setValue((double)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (double)this.e.precision());
            } else if (this.info.dataType == Float.TYPE) {
                this.info.setValue(Float.valueOf((float)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision()));
            }
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.getInstance().font;
        public final Component text;
        public final List<AbstractWidget> buttons;
        public final EntryInfo info;
        public boolean centered = false;
        public MultiLineTextWidget title;

        public ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            if (info != null && info.comment != null) {
                this.centered = info.comment.centered();
            }
            int scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            if (!(text == null || text.getString().contains("spacer") && buttons.isEmpty())) {
                this.title = new MultiLineTextWidget(this.centered ? scaledWidth / 2 - textRenderer.width((FormattedText)text) / 2 : 12, 0, Component.translationArg((Message)text), textRenderer);
                this.title.setCentered(this.centered);
                if (info != null) {
                    this.title.setTooltip(info.getTooltip(false));
                }
                this.title.setMaxWidth(!buttons.isEmpty() ? buttons.get(buttons.size() > 2 ? buttons.size() - 1 : 0).getX() - 16 : scaledWidth - 24);
            }
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.setY(y);
                b.render(context, mouseX, mouseY, tickDelta);
            });
            if (this.title != null) {
                AbstractWidget abstractWidget;
                this.title.setY(y + 5);
                this.title.render(context, mouseX, mouseY, tickDelta);
                if (this.info.entry != null && !this.buttons.isEmpty() && (abstractWidget = this.buttons.getFirst()) instanceof AbstractWidget) {
                    AbstractWidget widget = abstractWidget;
                    int idMode = this.info.entry.idMode();
                    if (idMode != -1) {
                        context.renderItem(idMode == 0 ? ((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.tryParse((String)this.info.tempValue))).getDefaultInstance() : ((Block)BuiltInRegistries.BLOCK.getValue(ResourceLocation.tryParse((String)this.info.tempValue))).asItem().getDefaultInstance(), widget.getX() + widget.getWidth() - 18, y + 2);
                    }
                }
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.info != null && this.info.comment != null && !this.info.comment.url().isBlank()) {
                ConfirmLinkScreen.confirmLinkNow((Screen)Minecraft.getInstance().screen, (String)this.info.comment.url(), (boolean)true);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public List<? extends GuiEventListener> children() {
            return Lists.newArrayList(this.buttons);
        }

        public List<? extends NarratableEntry> narratables() {
            return Lists.newArrayList(this.buttons);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        public boolean renderHeaderSeparator = true;

        public MidnightConfigListWidget(Minecraft client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        public int scrollBarX() {
            return this.width - 7;
        }

        protected void renderListSeparators(GuiGraphics context) {
            if (this.renderHeaderSeparator) {
                super.renderListSeparators(context);
            } else {
                context.blit(RenderPipelines.GUI_TEXTURED, this.minecraft.level == null ? Screen.FOOTER_SEPARATOR : Screen.INWORLD_FOOTER_SEPARATOR, this.getX(), this.getBottom(), 0.0f, 0.0f, this.getWidth(), 2, 32, 2);
            }
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(buttons, text, info));
        }

        public void clear() {
            this.clearEntries();
        }

        public int getRowWidth() {
            return 10000;
        }
    }
}

