/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class NamedBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private LockCode lockKey = LockCode.NO_LOCK;
    @Nullable
    private Component name;

    protected NamedBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.lockKey = LockCode.fromTag((ValueInput)valueInput);
        this.name = NamedBlockEntity.parseCustomNameSafe((ValueInput)valueInput, (String)"CustomName");
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        this.lockKey.addToTag(valueOutput);
        valueOutput.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.name);
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected abstract Component getDefaultName();

    public boolean canOpen(Player player) {
        return NamedBlockEntity.canUnlock(player, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(Player player, LockCode code, Component displayName) {
        if (!player.isSpectator() && !code.unlocksWith(player.getMainHandItem())) {
            player.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{displayName}), true);
            player.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    protected abstract NonNullList<ItemStack> getItems();

    protected abstract void setItems(NonNullList<ItemStack> var1);

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return this.canOpen(player) ? this.createMenu(i, inventory) : null;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        this.name = (Component)componentGetter.get(DataComponents.CUSTOM_NAME);
        this.lockKey = (LockCode)componentGetter.getOrDefault(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
        ((ItemContainerContents)componentGetter.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        if (!this.lockKey.equals((Object)LockCode.NO_LOCK)) {
            components.set(DataComponents.LOCK, (Object)this.lockKey);
        }
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(ValueOutput valueOutput) {
        valueOutput.discard("CustomName");
        valueOutput.discard("lock");
        valueOutput.discard("Items");
    }
}

