/*
 * Decompiled with CFR 0.152.
 */
package fuzs.netherchested.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.LimitlessContainerUtils;
import fuzs.limitlesscontainers.api.limitlesscontainers.v1.MultipliedContainer;
import fuzs.netherchested.NetherChested;
import fuzs.netherchested.config.ServerConfig;
import fuzs.netherchested.init.ModRegistry;
import fuzs.netherchested.world.level.block.entity.NetherChestBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NetherChestBlock
extends EnderChestBlock
implements TickingEntityBlock<NetherChestBlockEntity> {
    public static final MapCodec<EnderChestBlock> CODEC = NetherChestBlock.simpleCodec(NetherChestBlock::new);

    public NetherChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<EnderChestBlock> codec() {
        return CODEC;
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GOLD);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean movedByPiston) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            return LimitlessContainerUtils.getRedstoneSignalFromContainer((MultipliedContainer)blockEntity2.getContainer());
        }
        return 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.getBlockState(pos.above()).isRedstoneConductor((BlockGetter)level, pos.above())) {
            return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide);
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (level.dimension() == Level.NETHER && ((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).netherExplosionStrength > 0) {
            level.removeBlock(pos, false);
            level.explode(null, level.damageSources().badRespawnPointExplosion(pos.getCenter()), null, pos.getCenter(), (float)((ServerConfig)NetherChested.CONFIG.get(ServerConfig.class)).netherExplosionStrength, true, Level.ExplosionInteraction.BLOCK);
        } else {
            MenuProvider menuProvider = this.getMenuProvider(state, level, pos);
            if (menuProvider != null) {
                player.openMenu(menuProvider);
                PiglinAi.angerNearbyPiglins((ServerLevel)((ServerLevel)level), (Player)player, (boolean)true);
            }
        }
        return InteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return super.getTicker(level, state, blockEntityType);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(state.hasProperty((Property)WATERLOGGED) && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || random.nextInt(2) != 0)) {
            double posX = (double)pos.getX() + 0.5 + 0.4375 * (double)(random.nextInt(2) * 2 - 1);
            double posY = (float)pos.getY() + random.nextFloat();
            double posZ = (double)pos.getZ() + 0.5 + 0.4375 * (double)(random.nextInt(2) * 2 - 1);
            double ySpeed = (double)random.nextFloat() * 0.015625;
            if (random.nextInt(7) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, posX, posY, posZ, 0.0, ySpeed * 4.0, 0.0);
            } else {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, posX, posY, posZ, 0.0, ySpeed, 0.0);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NetherChestBlockEntity) {
            NetherChestBlockEntity blockEntity2 = (NetherChestBlockEntity)blockEntity;
            blockEntity2.recheckOpen();
        }
    }

    public BlockEntityType<? extends NetherChestBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.NETHER_CHEST_BLOCK_ENTITY_TYPE.value();
    }
}

