/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.wind.math;

import de.cheaterpaul.fallingleaves.wind.math.ITriangularDistribution;
import net.minecraft.util.RandomSource;

public class TriangularDistribution
implements ITriangularDistribution {
    public final float a;
    public final float b;
    public final float c;
    protected final float f;

    public TriangularDistribution(float a, float b, float c) {
        if (!(a < b && a <= c && c <= b)) {
            throw new IllegalArgumentException(String.format("not %f <= %f <= %f", Float.valueOf(a), Float.valueOf(b), Float.valueOf(c)));
        }
        this.a = a;
        this.b = b;
        this.c = c;
        this.f = (c - a) / (b - a);
    }

    @Override
    public float sample(RandomSource random) {
        float u = random.nextFloat();
        if (u < this.f) {
            return this.a + (float)Math.sqrt(u * (this.b - this.a) * (this.c - this.a));
        }
        return this.b - (float)Math.sqrt((1.0f - u) * (this.b - this.a) * (this.b - this.c));
    }
}

