/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.wind.math;

import de.cheaterpaul.fallingleaves.wind.math.NoiseFunction;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNullByDefault;

@NotNullByDefault
public class SmoothNoise {
    protected final int tickInterval;
    protected final NoiseFunction nextNoise;
    protected float leftNoise;
    protected float rightNoise;
    protected int ticks = 0;
    protected float t;

    public SmoothNoise(int tickInterval, float initial, NoiseFunction nextNoise) {
        if (tickInterval < 1) {
            throw new IllegalArgumentException(String.format("tickInterval %d < 1", tickInterval));
        }
        this.tickInterval = tickInterval;
        this.nextNoise = nextNoise;
        this.leftNoise = 0.0f;
        this.rightNoise = initial;
    }

    public static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public void tick(RandomSource random) {
        ++this.ticks;
        if (this.ticks == this.tickInterval) {
            this.ticks = 0;
            this.leftNoise = this.rightNoise;
            this.rightNoise = this.nextNoise.apply(this.leftNoise, random);
        }
        this.t = (float)this.ticks / (float)this.tickInterval;
    }

    public float getLeftNoise() {
        return this.leftNoise;
    }

    public float getRightNoise() {
        return this.rightNoise;
    }

    public float getLerp() {
        return this.leftNoise + this.t * (this.rightNoise - this.leftNoise);
    }

    public float getNoise() {
        return this.leftNoise + SmoothNoise.smoothStep(this.t) * (this.rightNoise - this.leftNoise);
    }
}

