/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.wind;

import com.mojang.logging.LogUtils;
import de.cheaterpaul.fallingleaves.wind.math.ITriangularDistribution;
import de.cheaterpaul.fallingleaves.wind.math.TriangularDistribution;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNullByDefault;
import org.slf4j.Logger;

@NotNullByDefault
public class WindState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean wasRaining;
    private boolean wasThundering;
    private State state = State.NO_WIND;
    private int duration;

    public void tick(ClientLevel level) {
        boolean weatherChanged;
        --this.duration;
        boolean isRaining = level.getLevelData().isRaining();
        boolean isThundering = level.isThundering();
        boolean bl = weatherChanged = this.wasRaining != isRaining || this.wasThundering != isThundering;
        if (weatherChanged || this.duration <= 0) {
            if (isThundering) {
                this.state = StateGroup.STORM.getRandomState(level.random);
            } else {
                this.changeWind(level);
            }
            this.duration = 7200;
            LOGGER.trace("new wind state {}", (Object)this.state);
        }
        this.wasRaining = isRaining;
        this.wasThundering = isThundering;
    }

    public void changeWind(ClientLevel level) {
        int index = level.random.nextInt(2);
        this.state = StateGroup.values()[index].getRandomState(level.random);
    }

    public void changeWind(State state) {
        this.state = state;
        this.duration = 7200;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        NO_WIND,
        CALM(0.05f, 0.05f, 0.2f),
        LIGHT(0.1f, 0.1f, 0.5f),
        WINDY(0.15f, 0.3f, 0.7f),
        VERY_WINDY(0.2f, 0.5f, 0.9f),
        STORMY(0.25f, 0.7f, 1.1f),
        HURRICANE(0.3f, 0.9f, 1.3f);

        public final ITriangularDistribution velocityDistribution;

        private State() {
            this.velocityDistribution = random -> 0.0f;
        }

        private State(float minSpeed, float likelySpeed, float maxSpeed) {
            this.velocityDistribution = new TriangularDistribution(minSpeed, maxSpeed, likelySpeed);
        }
    }

    public static enum StateGroup {
        CALM(State.NO_WIND, State.CALM, State.LIGHT),
        WIND(State.LIGHT, State.WINDY, State.VERY_WINDY),
        STORM(State.VERY_WINDY, State.STORMY, State.HURRICANE);

        final List<State> states;

        private StateGroup(State ... states) {
            this.states = List.of(states);
        }

        public List<State> getStates() {
            return this.states;
        }

        public State getRandomState(RandomSource random) {
            return this.states.get(random.nextInt(this.states.size()));
        }
    }
}

