/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.wind;

import de.cheaterpaul.fallingleaves.config.Config;
import de.cheaterpaul.fallingleaves.wind.WindState;
import de.cheaterpaul.fallingleaves.wind.math.SmoothNoise;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class Wind {
    private static final float TAU = (float)Math.PI * 2;
    private final WindState state = new WindState();
    private final ClientLevel level;
    private final SmoothNoise velocityNoise;
    private final SmoothNoise directionTrendNoise;
    private final SmoothNoise directionNoise;
    private float windX;
    private float windZ;
    private boolean active = true;
    private static final int WIND_UPDATE_INTERVAL = 5;
    private int tickCounter = 0;
    private float gustStrength = 0.0f;
    private float gustDuration = 0.0f;
    private float gustFadeTime = 0.0f;

    public Wind(ClientLevel level) {
        this.level = level;
        this.velocityNoise = new SmoothNoise(40, 0.0f, (old, random) -> random.nextFloat());
        this.directionTrendNoise = new SmoothNoise(36000, 0.0f, (old, random) -> random.nextFloat() * ((float)Math.PI * 2));
        this.directionNoise = new SmoothNoise(200, 0.0f, (old, random) -> (2.0f * random.nextFloat() - 1.0f) * ((float)Math.PI * 2) / 8.0f);
    }

    public void tick() {
        boolean updateWind;
        if (this.checkStatus()) {
            return;
        }
        ++this.tickCounter;
        boolean bl = updateWind = this.tickCounter % 5 == 0;
        if (updateWind) {
            this.state.tick(this.level);
            this.velocityNoise.tick(this.level.getRandom());
            this.directionTrendNoise.tick(this.level.getRandom());
            this.directionNoise.tick(this.level.getRandom());
            float stateStrength = this.state.getState().velocityDistribution.sample(this.level.getRandom());
            float noiseModifier = this.velocityNoise.getNoise();
            float strength = stateStrength * (0.8f + 0.4f * noiseModifier);
            float direction = this.directionTrendNoise.getLerp() + this.directionNoise.getNoise();
            float baseWindX = strength * Mth.cos((float)direction);
            float baseWindZ = strength * Mth.sin((float)direction);
            if (this.level.getRandom().nextFloat() < 0.05f && this.gustDuration <= 0.0f) {
                this.gustStrength = 0.2f + this.level.getRandom().nextFloat() * 0.3f;
                this.gustDuration = 20 + this.level.getRandom().nextInt(40);
                this.gustFadeTime = 10 + this.level.getRandom().nextInt(20);
            }
            if (this.gustDuration > 0.0f) {
                float gustFactor = this.gustDuration < this.gustFadeTime ? this.gustDuration / this.gustFadeTime : 1.0f;
                this.windX = baseWindX * (1.0f + this.gustStrength * gustFactor);
                this.windZ = baseWindZ * (1.0f + this.gustStrength * gustFactor);
                this.gustDuration -= 1.0f;
            } else {
                this.windX = baseWindX;
                this.windZ = baseWindZ;
            }
        }
    }

    public void changeWind() {
        this.state.changeWind(this.level);
    }

    public void changeWind(WindState.State state) {
        this.state.changeWind(state);
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean checkStatus() {
        if (!this.hasWind()) {
            this.deactivate();
            return true;
        }
        if (!this.active) {
            this.active = true;
        }
        return false;
    }

    private boolean hasWind() {
        return Config.CONFIG.wind.hasWind((Level)this.level);
    }

    private void deactivate() {
        if (this.active) {
            this.active = false;
            this.windX = 0.0f;
            this.windZ = 0.0f;
        }
    }

    public float getWindX() {
        return this.windX;
    }

    public float getWindZ() {
        return this.windZ;
    }
}

