/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.snow;

import de.cheaterpaul.fallingleaves.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Snow {
    public void makeSnowParticles(Level level, BlockPos pos, RandomSource randomSource, BlockState state, BlockPos posBelow, float leafParticleChance) {
        if (((Boolean)Config.CONFIG.snow.enabled.get()).booleanValue() && !(randomSource.nextFloat() >= leafParticleChance) && !Block.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)level, posBelow), (Direction)Direction.UP)) {
            this.spawnSnowParticles(level, pos, randomSource);
        }
    }

    public void makeDecayingSnowParticles(Level level, BlockPos pos, RandomSource randomSource, BlockState state, BlockPos posBelow) {
        if (((Boolean)Config.CONFIG.snow.enabled.get()).booleanValue() && !Block.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)level, posBelow), (Direction)Direction.UP)) {
            for (int i = 0; i < 5; ++i) {
                this.spawnSnowParticles(level, pos, randomSource);
            }
        }
    }

    public void makeAttackSnowParticles(ClientLevel level, BlockPos pos, BlockState blockState, RandomSource randomSource, BlockPos posBelow, BlockState stateBelow) {
    }

    public void spawnSnowParticles(Level level, BlockPos pos, RandomSource randomSource) {
        if (this.canSpawnSnow(level, pos)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)randomSource, (ParticleOptions)ParticleTypes.SNOWFLAKE);
        }
    }

    private boolean canSpawnSnow(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            BlockState state = level.getBlockState(pos.above(i));
            if (state.is(BlockTags.SNOW)) {
                return true;
            }
            if (state.is(BlockTags.LEAVES)) continue;
            return false;
        }
        return false;
    }
}

