/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves.vanilla;

import de.cheaterpaul.fallingleaves.leaves.ILeavesSpawner;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafSetting;
import de.cheaterpaul.fallingleaves.leaves.vanilla.ILeavesBlockExtension;
import de.cheaterpaul.fallingleaves.seasons.ISeasonProvider;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VanillaLeavesSpawner
implements ILeavesSpawner {
    private ISeasonProvider seasonProvider;

    public VanillaLeavesSpawner(ISeasonProvider seasonProvider) {
        this.seasonProvider = seasonProvider;
    }

    @Override
    public void updateSeasonProvider(ISeasonProvider seasonProvider) {
        this.seasonProvider = seasonProvider;
    }

    @Override
    public void trySpawnFallingLeavesParticle(ClientLevel level, BlockPos pos, BlockState state, RandomSource randomSource) {
        Block block = state.getBlock();
        if (block instanceof ILeavesBlockExtension) {
            ILeavesBlockExtension leavesBlock = (ILeavesBlockExtension)block;
            leavesBlock.fallingLeaves$spawnLeaves((Level)level, pos, randomSource);
        }
    }

    @Override
    public void spawnFallingLeavesParticle(ClientLevel level, BlockPos pos, BlockState state, RandomSource randomSource, LeafSetting.LoadedLeafSetting leafSetting) {
        Block block = state.getBlock();
        if (block instanceof ILeavesBlockExtension) {
            ILeavesBlockExtension leavesBlock = (ILeavesBlockExtension)block;
            leavesBlock.fallingLeaves$spawnLeaves((Level)level, pos, randomSource);
        }
    }

    @Override
    public void makeFallingLeavesParticles(ClientLevel level, BlockPos blockPos, RandomSource randomSource, BlockState belowState, BlockPos belowPos) {
        Block block = level.getBlockState(blockPos).getBlock();
        if (block instanceof ILeavesBlockExtension) {
            ILeavesBlockExtension leavesBlock = (ILeavesBlockExtension)block;
            leavesBlock.fallingLeaves$makeFallingLeavesParticles((Level)level, blockPos, randomSource, belowState, belowPos);
        }
    }

    @Override
    public boolean isVanilla() {
        return true;
    }
}

