/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves.mod.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;

@EventBusSubscriber(modid="fallingleaves", value={Dist.CLIENT})
public class TextureCache {
    public static final Map<ResourceLocation, Data> INST = new HashMap<ResourceLocation, Data>();
    private static final Map<BlockColorKey, Integer> BLOCK_COLOR_CACHE = new HashMap<BlockColorKey, Integer>();
    private static final Map<CombinedColorKey, double[]> COMBINED_COLOR_CACHE = new HashMap<CombinedColorKey, double[]>();

    private TextureCache() {
    }

    public static Integer getBlockColor(BlockState state, BlockPos pos) {
        return BLOCK_COLOR_CACHE.get(new BlockColorKey(state, pos));
    }

    public static void putBlockColor(BlockState state, BlockPos pos, int color) {
        BLOCK_COLOR_CACHE.put(new BlockColorKey(state, pos), color);
    }

    public static double[] getCombinedColor(ResourceLocation textureId, int blockColor) {
        return COMBINED_COLOR_CACHE.get(new CombinedColorKey(textureId, blockColor));
    }

    public static void putCombinedColor(ResourceLocation textureId, int blockColor, double[] color) {
        COMBINED_COLOR_CACHE.put(new CombinedColorKey(textureId, blockColor), color);
    }

    @SubscribeEvent
    public static void onReload(TextureAtlasStitchedEvent event) {
        INST.clear();
        BLOCK_COLOR_CACHE.clear();
        COMBINED_COLOR_CACHE.clear();
    }

    public record BlockColorKey(BlockState state, BlockPos pos) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockColorKey that = (BlockColorKey)o;
            return Objects.equals(this.state, that.state) && this.pos.getX() == that.pos.getX() && this.pos.getY() == that.pos.getY() && this.pos.getZ() == that.pos.getZ();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.state, this.pos.getX(), this.pos.getY(), this.pos.getZ());
        }
    }

    public record CombinedColorKey(ResourceLocation textureId, int blockColor) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CombinedColorKey that = (CombinedColorKey)o;
            return this.blockColor == that.blockColor && Objects.equals(this.textureId, that.textureId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.textureId, this.blockColor);
        }
    }

    public record Data(double[] color) {
        public Data {
            if (color.length != 3) {
                throw new IllegalArgumentException("texture color should have 3 components");
            }
        }

        public double[] getColor() {
            return Arrays.copyOf(this.color, this.color.length);
        }
    }
}

