/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves.mod.util;

import com.mojang.blaze3d.platform.NativeImage;
import de.cheaterpaul.fallingleaves.leaves.mod.util.TextureCache;
import de.cheaterpaul.fallingleaves.mixin.NativeImageAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryUtil;

public class LeafHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static double[] getBlockTextureColor(BlockState state, ClientLevel level, BlockPos pos) {
        int blockColor;
        boolean shouldColor;
        TextureAtlasSprite sprite;
        BlockStateModel blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        List quads = blockModel.collectParts((BlockAndTintGetter)level, pos, state, level.random).stream().flatMap(x -> x.getQuads(Direction.DOWN).stream()).toList();
        if (quads.isEmpty()) {
            sprite = blockModel.particleIcon((BlockAndTintGetter)level, pos, state);
            shouldColor = true;
        } else {
            BakedQuad quad = (BakedQuad)quads.getFirst();
            sprite = quad.sprite();
            shouldColor = quad.isTinted();
        }
        SpriteContents contents = sprite.contents();
        ResourceLocation name = contents.name();
        Integer cachedBlockColor = TextureCache.getBlockColor(state, pos);
        if (cachedBlockColor != null) {
            blockColor = cachedBlockColor;
        } else {
            blockColor = shouldColor ? Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)level, pos, 0) : -1;
            TextureCache.putBlockColor(state, pos, blockColor);
        }
        return LeafHelper.calculateLeafColor(name, contents.byMipLevel[0], blockColor);
    }

    private static double[] calculateLeafColor(ResourceLocation spriteId, NativeImage texture, int blockColor) {
        double[] cachedCombinedColor = TextureCache.getCombinedColor(spriteId, blockColor);
        if (cachedCombinedColor != null) {
            return cachedCombinedColor;
        }
        double[] textureColor = TextureCache.INST.computeIfAbsent(spriteId, loc -> {
            double[] doubles = LeafHelper.averageColor(texture);
            LogManager.getLogger().debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)doubles);
            return new TextureCache.Data(doubles);
        }).getColor();
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        TextureCache.putCombinedColor(spriteId, blockColor, textureColor);
        return textureColor;
    }

    public static double[] averageColor(NativeImage image) {
        if (image.format() != NativeImage.Format.RGBA) {
            LOGGER.error("RGBA image required, was {}", (Object)image.format());
            return new double[]{1.0, 1.0, 1.0};
        }
        long pixels = ((NativeImageAccessor)image).getPixels();
        if (pixels == 0L) {
            LOGGER.error("image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pixels + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }
}

