/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves.mod.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cheaterpaul.fallingleaves.particle.ColoredSpriteProvider;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public record LeafType(List<Texture> textures, float spawnModifier, float sizeModifier, float lifeSpanModifier, SeasonModifier seasonModifier) {
    public static final Codec<LeafType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Texture.CODEC.listOf().fieldOf("textures").forGetter(LeafType::textures), (App)Codec.FLOAT.optionalFieldOf("spawnModifier", (Object)Float.valueOf(1.0f)).forGetter(LeafType::spawnModifier), (App)Codec.FLOAT.optionalFieldOf("sizeModifier", (Object)Float.valueOf(1.0f)).forGetter(LeafType::sizeModifier), (App)Codec.FLOAT.optionalFieldOf("lifeSpanModifier", (Object)Float.valueOf(1.0f)).forGetter(LeafType::lifeSpanModifier), (App)SeasonModifier.CODEC.optionalFieldOf("season", (Object)SeasonModifier.DEFAULT).forGetter(LeafType::seasonModifier)).apply((Applicative)inst, LeafType::new));

    public LeafType(float spawnModifier, float sizeModifier, float lifeSpanModifier, ResourceLocation ... textures) {
        this(spawnModifier, sizeModifier, lifeSpanModifier, SeasonModifier.DEFAULT, textures);
    }

    public LeafType(float spawnModifier, float sizeModifier, float lifeSpanModifier, SeasonModifier seasonModifier, ResourceLocation ... textures) {
        this(Stream.of(textures).map(Texture::new).toList(), spawnModifier, sizeModifier, lifeSpanModifier, seasonModifier);
    }

    public LeafType(float spawnModifier, float sizeModifier, float lifeSpanModifier, Texture ... textures) {
        this(spawnModifier, sizeModifier, lifeSpanModifier, SeasonModifier.DEFAULT, textures);
    }

    public LeafType(float spawnModifier, float sizeModifier, float lifeSpanModifier, SeasonModifier seasonModifier, Texture ... textures) {
        this(Stream.of(textures).toList(), spawnModifier, sizeModifier, lifeSpanModifier, seasonModifier);
    }

    public record SeasonModifier(Season spring, Season summer, Season autumn, Season winter) {
        public static final SeasonModifier DEFAULT = new SeasonModifier(new Season(0.0f, 0.0f, 0.0f), new Season(0.0f, 0.4f, 0.8f), new Season(1.0f, 1.5f, 1.0f), new Season(0.0f, 0.0f, 0.0f));
        public static final Codec<SeasonModifier> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Season.CODEC.fieldOf("spring").forGetter(SeasonModifier::spring), (App)Season.CODEC.fieldOf("summer").forGetter(SeasonModifier::summer), (App)Season.CODEC.fieldOf("autumn").forGetter(SeasonModifier::autumn), (App)Season.CODEC.fieldOf("winter").forGetter(SeasonModifier::winter)).apply((Applicative)inst, SeasonModifier::new));
    }

    public record Texture(ResourceLocation texture, boolean isTinted, float sizeModifier) {
        public static final Codec<Texture> CODEC = NeoForgeExtraCodecs.withAlternative((Codec)ResourceLocation.CODEC.flatXmap(x -> DataResult.success((Object)new Texture((ResourceLocation)x, false, 1.0f)), x -> {
            if (!x.isTinted && x.sizeModifier == 1.0f) {
                return DataResult.success((Object)x.texture);
            }
            return DataResult.error(() -> "can not serialize with different isTinted and sizeModifier values");
        }), (Codec)RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Texture::texture), (App)Codec.BOOL.optionalFieldOf("isTinted", (Object)false).forGetter(Texture::isTinted), (App)Codec.FLOAT.optionalFieldOf("size", (Object)Float.valueOf(1.0f)).forGetter(Texture::sizeModifier)).apply((Applicative)inst, Texture::new)));

        public Texture(ResourceLocation texture) {
            this(texture, false, 1.0f);
        }

        public Texture(ResourceLocation texture, boolean isTinted) {
            this(texture, isTinted, 1.0f);
        }
    }

    public record Season(float early, float mid, float late) {
        public static final Codec<Season> CODEC = NeoForgeExtraCodecs.withAlternative((Codec)Codec.FLOAT.flatXmap(x -> DataResult.success((Object)new Season(x.floatValue(), x.floatValue(), x.floatValue())), season -> {
            if (season.early == season.mid && season.mid == season.late) {
                return DataResult.success((Object)Float.valueOf(season.mid));
            }
            return DataResult.error(() -> "can not serialize with different early, mid and late values");
        }), (Codec)RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("early").forGetter(Season::early), (App)Codec.FLOAT.fieldOf("mid").forGetter(Season::mid), (App)Codec.FLOAT.fieldOf("late").forGetter(Season::late)).apply((Applicative)inst, Season::new)));

        public Season(float mid) {
            this(mid, mid, mid);
        }
    }

    public record LoadedLeafType(LeafType type, ColoredSpriteProvider spriteSet) {
    }
}

