/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves.mod;

import de.cheaterpaul.fallingleaves.config.Config;
import de.cheaterpaul.fallingleaves.data.LeafLoader;
import de.cheaterpaul.fallingleaves.leaves.ILeavesSpawner;
import de.cheaterpaul.fallingleaves.leaves.mod.FallingLeafParticle;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafSetting;
import de.cheaterpaul.fallingleaves.leaves.mod.util.LeafHelper;
import de.cheaterpaul.fallingleaves.seasons.ISeasonProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModLeavesSpawner
implements ILeavesSpawner {
    private final ParticleEngine particleEngine;
    private final FallingLeafParticle.LeavesParticleFactory particleFactory;
    private ISeasonProvider seasonProvider;

    public ModLeavesSpawner(ISeasonProvider seasonProvider) {
        this.seasonProvider = seasonProvider;
        this.particleEngine = Minecraft.getInstance().particleEngine;
        this.particleFactory = new FallingLeafParticle.LeavesParticleFactory();
    }

    @Override
    public void updateSeasonProvider(ISeasonProvider seasonProvider) {
        this.seasonProvider = seasonProvider;
    }

    @Override
    public void spawnFallingLeavesParticle(ClientLevel level, BlockPos pos, BlockState state, RandomSource randomSource, LeafSetting.LoadedLeafSetting leafSetting) {
        double b;
        double g;
        double[] color;
        double r;
        double z;
        double y;
        double x = (double)pos.getX() + randomSource.nextDouble();
        Particle particle = this.particleFactory.createParticle(null, level, x, y = (double)pos.getY() - randomSource.nextDouble() / 3.0, z = (double)pos.getZ() + randomSource.nextDouble(), r = (color = LeafHelper.getBlockTextureColor(state, level, pos))[0], g = color[1], b = color[2], leafSetting);
        if (particle != null) {
            this.particleEngine.add(particle);
        }
    }

    @Override
    public void trySpawnFallingLeavesParticle(ClientLevel level, BlockPos pos, BlockState state, RandomSource randomSource) {
        LeafSetting.LoadedLeafSetting leafSetting = LeafLoader.getOrDefault(state.getBlock());
        if (this.leafChance(leafSetting, randomSource)) {
            this.spawnFallingLeavesParticle(level, pos, state, randomSource, leafSetting);
        }
    }

    @Override
    public void makeFallingLeavesParticles(ClientLevel level, BlockPos blockPos, RandomSource randomSource, BlockState belowState, BlockPos belowPos) {
        if (this.canSpawnParticle(level, blockPos, belowState, belowPos)) {
            this.trySpawnFallingLeavesParticle(level, blockPos, level.getBlockState(blockPos), randomSource);
        }
    }

    private boolean canSpawnParticle(ClientLevel level, BlockPos pos, BlockState belowState, BlockPos belowPos) {
        if (Block.isFaceFull((VoxelShape)belowState.getCollisionShape((BlockGetter)level, belowPos), (Direction)Direction.UP)) {
            return false;
        }
        double y2 = (double)pos.getY() - (Double)Config.CONFIG.leaves.mod.minimumFreeSpaceBelow.get();
        AABB collisionBox = new AABB((double)pos.getX() + 0.1, (double)pos.getY(), (double)pos.getZ() + 0.1, (double)pos.getX() + 0.9, y2, (double)pos.getZ() + 0.9);
        return !level.getBlockCollisions(null, collisionBox).iterator().hasNext();
    }

    private boolean leafChance(LeafSetting.LoadedLeafSetting leafSetting, RandomSource randomSource) {
        double spawnChance = (double)leafSetting.leafType().type().spawnModifier() * leafSetting.setting().spawnRate();
        spawnChance *= (double)((float)((Integer)Config.CONFIG.leaves.mod.leafSpawnRate.get()).intValue() / 500.0f);
        return randomSource.nextDouble() < (spawnChance *= (double)this.seasonProvider.getSeasonModifier(leafSetting.leafType().type()));
    }

    @Override
    public boolean isVanilla() {
        return false;
    }
}

