/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves.mod;

import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cheaterpaul.fallingleaves.config.Config;
import de.cheaterpaul.fallingleaves.data.LeafLoader;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafSetting;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafType;
import de.cheaterpaul.fallingleaves.leaves.mod.util.RenderSettings;
import de.cheaterpaul.fallingleaves.particle.ColoredSpriteProvider;
import de.cheaterpaul.fallingleaves.wind.IWindLevel;
import de.cheaterpaul.fallingleaves.wind.Wind;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class FallingLeafParticle
extends TextureSheetParticle {
    public static final ParticleRenderType LEAVES_SHEET = new ParticleRenderType("FALLINGLEAVES_PARTICLE_SHEET_TRANSLUCENT", RenderType.translucentParticle((ResourceLocation)RenderSettings.LEAVES_ATLAS), true);
    protected static final float TAU = (float)Math.PI * 2;
    protected static final int FADE_DURATION = 16;
    protected static final double WATER_FRICTION = 0.05;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);

    protected FallingLeafParticle(ClientLevel clientWorld, double x, double y, double z, double r, double g, double b, @NotNull LeafSetting.LoadedLeafSetting provider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        LeafType.LoadedLeafType loadedType = provider.leafType();
        LeafType type = loadedType.type();
        this.gravity = 0.08f + this.random.nextFloat() * 0.04f;
        this.windCoefficient = 0.3f + this.random.nextFloat() * 0.2f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.hasPhysics = true;
        this.lifetime = (int)((float)((Integer)Config.CONFIG.leaves.mod.leafLifespan.get()).intValue() * type.lifeSpanModifier());
        this.rCol = (float)r;
        this.gCol = (float)g;
        this.bCol = (float)b;
        this.maxRotateTime = (3 + this.random.nextInt(5)) * 20;
        this.maxRotateSpeed = (float)(this.random.nextBoolean() ? -1 : 1) * (0.1f + 2.4f * this.random.nextFloat()) * ((float)Math.PI * 2) / 20.0f;
        this.roll = this.oRoll = this.random.nextFloat() * ((float)Math.PI * 2);
        float mod = (2.0f + this.random.nextFloat()) / 2.5f;
        this.quadSize = (float)((Integer)Config.CONFIG.leaves.mod.leafSize.get()).intValue() / 50.0f * type.sizeModifier() * mod;
        this.pickSprite(loadedType.spriteSet());
    }

    public void pickSprite(ColoredSpriteProvider sprite) {
        ColoredSpriteProvider.TextureSprite textureSprite = sprite.get(this.random);
        this.setSprite(textureSprite.sprite());
        if (textureSprite.isTinted()) {
            this.rCol = 1.0f;
            this.gCol = 1.0f;
            this.bCol = 1.0f;
        }
        this.quadSize *= textureSprite.sizeModifier();
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.oRoll = this.roll;
        ++this.age;
        if (this.age >= this.lifetime + 1 - 16) {
            this.alpha -= 0.0625f;
        }
        if (this.age >= this.lifetime) {
            this.remove();
            return;
        }
        if (this.level.getFluidState(new BlockPos((int)this.x, (int)this.y, (int)this.z)).is(FluidTags.WATER)) {
            this.yd = 0.0;
            this.rotateTime = 0;
            this.xd *= 0.95;
            this.zd *= 0.95;
        } else {
            this.yd -= 0.02 * (double)this.gravity;
            if (!this.onGround) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.roll += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
                Wind wind = ((IWindLevel)this.level).fallingLeaves$getWind();
                this.xd += ((double)wind.getWindX() - this.xd) * (double)this.windCoefficient / 60.0;
                this.zd += ((double)wind.getWindZ() - this.zd) * (double)this.windCoefficient / 60.0;
            } else {
                this.rotateTime = 0;
                this.xd = 0.0;
                this.zd = 0.0;
            }
        }
        float fadingDuration = Math.min(40.0f, (float)this.lifetime / 4.0f);
        int remainingLifespan = this.lifetime - this.age;
        if ((float)remainingLifespan < fadingDuration) {
            this.alpha = (float)remainingLifespan / fadingDuration;
        }
        if (!this.onGround || this.checkGroundCollision()) {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    private boolean checkGroundCollision() {
        BlockPos blockPos = new BlockPos((int)this.x, (int)this.y, (int)this.z);
        List<VoxelShape> collision = List.of(this.level.getBlockState(blockPos).getCollisionShape((BlockGetter)this.level, blockPos), this.level.getBlockState(blockPos.below()).getCollisionShape((BlockGetter)this.level, blockPos.below()));
        return Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)this.getBoundingBox().move(0.0, 0.1, 0.0), collision, (double)0.1) > 0.1;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return LEAVES_SHEET;
    }

    public void move(double pX, double pY, double pZ) {
        double d0 = pX;
        double d1 = pY;
        double d2 = pZ;
        if (this.hasPhysics && (pX != 0.0 || pY != 0.0 || pZ != 0.0) && pX * pX + pY * pY + pZ * pZ < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(pX, pY, pZ), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            pX = vec3.x;
            pY = vec3.y;
            pZ = vec3.z;
            List entities = this.level.getEntities(null, this.getBoundingBox());
            if (!entities.isEmpty() && this.random.nextFloat() > 0.4f) {
                Entity first = (Entity)entities.getFirst();
                pX += first.getDeltaMovement().x;
                pZ += first.getDeltaMovement().z;
            }
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(pX, pY, pZ));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = d1 != pY && d1 < 0.0;
        if (d0 != pX) {
            this.xd = 0.0;
        }
        if (d2 != pZ) {
            this.zd = 0.0;
        }
        if (this.onGround && ((Boolean)Config.CONFIG.leaves.mod.particlesDisappearOnGroundContact.get()).booleanValue()) {
            this.remove();
        }
    }

    public void render(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        Quaternionf q = new Quaternionf();
        if (this.onGround) {
            q.rotateX(-1.5707964f);
            q.rotateZ((float)((Object)((Object)this)).hashCode());
            Vec3 pos = this.getPos();
            Vec3 position = pRenderInfo.getPosition();
            Vec3 subtract = position.subtract(pos);
            if (subtract.y < 0.0) {
                q.rotateY((float)Math.PI);
                q.rotateZ(1.5707964f);
            }
        } else {
            this.getFacingCameraMode().setRotation(q, pRenderInfo, pPartialTicks);
            if ((double)this.roll != 0.0) {
                q.rotateZ(Mth.lerp((float)pPartialTicks, (float)this.oRoll, (float)this.roll));
            }
        }
        super.renderRotatedQuad(pBuffer, pRenderInfo, q, pPartialTicks);
    }

    protected void renderRotatedQuad(@NotNull VertexConsumer pBuffer, @NotNull Quaternionf pQuaternion, float pX, float pY, float pZ, float pPartialTicks) {
        super.renderRotatedQuad(pBuffer, pQuaternion, pX, pY + (switch (((Object)((Object)this)).hashCode() % 3) {
            case 0 -> 0.01f;
            case 1 -> 0.02f;
            default -> 0.03f;
        }), pZ, pPartialTicks);
    }

    public static class LeavesParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b) {
            return this.createParticle(parameters, world, x, y, z, r, g, b, null);
        }

        public Particle createParticle(@Nullable SimpleParticleType parameters, @NotNull ClientLevel world, double x, double y, double z, double r, double g, double b, @Nullable LeafSetting.LoadedLeafSetting settings) {
            if (settings == null) {
                settings = LeafLoader.getDefault();
            }
            return new FallingLeafParticle(world, x, y, z, r, g, b, settings);
        }
    }
}

