/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.leaves;

import de.cheaterpaul.fallingleaves.config.Config;
import de.cheaterpaul.fallingleaves.leaves.ILeavesSpawner;
import de.cheaterpaul.fallingleaves.leaves.mod.ModLeavesSpawner;
import de.cheaterpaul.fallingleaves.leaves.vanilla.VanillaLeavesSpawner;
import de.cheaterpaul.fallingleaves.seasons.ISeasonProvider;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Leaves {
    private final ClientLevel level;
    private ILeavesSpawner spawner;

    public Leaves(ClientLevel level) {
        this.level = level;
        this.checkSpawner((Boolean)Config.CONFIG.leaves.enabled.get() == false);
    }

    public void checkSpawner(boolean useVanilla) {
        ISeasonProvider seasonProvider = this.createSeasonProvider();
        if (this.spawner == null || this.spawner.isVanilla() != useVanilla) {
            this.spawner = useVanilla ? new VanillaLeavesSpawner(seasonProvider) : new ModLeavesSpawner(seasonProvider);
        } else {
            this.spawner.updateSeasonProvider(seasonProvider);
        }
    }

    public ISeasonProvider createSeasonProvider() {
        return ISeasonProvider.DEFAULT;
    }

    public void makeDecayingLeavesParticles(ClientLevel level, BlockPos pos, BlockState state, RandomSource randomSource, BlockState stateBelow, BlockPos posBelow) {
        if (((Boolean)Config.CONFIG.snow.enabled.get()).booleanValue() && !Block.isFaceFull((VoxelShape)stateBelow.getCollisionShape((BlockGetter)level, posBelow), (Direction)Direction.UP)) {
            for (int i = 0; i < 10; ++i) {
                this.spawner.spawnFallingLeavesParticle(level, pos, state, randomSource);
            }
        }
    }

    public void makeLeavesParticles(ClientLevel level, BlockPos pos, RandomSource randomSource, BlockState state, BlockPos posBelow) {
        this.spawner.makeFallingLeavesParticles(level, pos, randomSource, state, posBelow);
    }

    public void makeAttackLeavesParticles(ClientLevel level, BlockPos pos, BlockState blockState, RandomSource random, BlockPos posBelow, BlockState stateBelow) {
        if (((Boolean)Config.CONFIG.snow.enabled.get()).booleanValue() && !Block.isFaceFull((VoxelShape)stateBelow.getCollisionShape((BlockGetter)level, posBelow), (Direction)Direction.UP)) {
            for (int i = 0; i < 4; ++i) {
                this.spawner.spawnFallingLeavesParticle(level, pos, blockState, random);
            }
        }
    }
}

