/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data.provider;

import com.mojang.logging.LogUtils;
import de.cheaterpaul.fallingleaves.data.provider.LeafSettingProvider;
import de.cheaterpaul.fallingleaves.data.provider.LeafTypeProvider;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafSetting;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafType;
import de.cheaterpaul.fallingleaves.leaves.mod.util.RenderSettings;
import de.cheaterpaul.fallingleaves.particle.ColoredSpriteProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LeafProvider
implements PreparableReloadListener {
    public static final ResourceLocation LEAF_LISTENER = ResourceLocation.fromNamespaceAndPath((String)"fallingleaves", (String)"leaves");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TextureAtlas textureAtlas;
    private final LeafSettingProvider leafSettingProvider;
    private final LeafTypeProvider leafTypeProvider;
    private Map<ResourceLocation, LeafType.LoadedLeafType> loadedLeaves = Map.of();
    private Map<ResourceLocation, LeafSetting.LoadedLeafSetting> loadedSettings = Map.of();

    public LeafProvider() {
        this.textureAtlas = new TextureAtlas(RenderSettings.LEAVES_ATLAS);
        Minecraft.getInstance().getTextureManager().register(this.textureAtlas.location(), (AbstractTexture)this.textureAtlas);
        this.leafSettingProvider = new LeafSettingProvider();
        this.leafTypeProvider = new LeafTypeProvider();
    }

    @NotNull
    public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull Executor executor, @NotNull Executor executor1) {
        CompletableFuture settingsReload = this.leafSettingProvider.reload(preparationBarrier, resourceManager, executor, executor1);
        CompletableFuture typesReload = this.leafTypeProvider.reload(preparationBarrier, resourceManager, executor, executor1);
        CompletionStage preparations = SpriteLoader.create((TextureAtlas)this.textureAtlas).loadAndStitch(resourceManager, RenderSettings.LEAVES_ATLAS, 0, executor).thenCompose(SpriteLoader.Preparations::waitForUpload);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{settingsReload, typesReload, preparations}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$2((CompletableFuture)preparations, arg_0), executor1);
    }

    public Map<ResourceLocation, LeafType.LoadedLeafType> getLoadedLeaves() {
        return this.loadedLeaves;
    }

    public Map<ResourceLocation, LeafSetting.LoadedLeafSetting> getLoadedSettings() {
        return this.loadedSettings;
    }

    private /* synthetic */ void lambda$reload$2(CompletableFuture preparations, Void param) {
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)preparations.join();
        this.textureAtlas.upload(spriteloader$preparations);
        HashMap spriteSets = new HashMap();
        HashMap leafSprites = new HashMap();
        ColoredSpriteProvider.TextureSprite notFound = new ColoredSpriteProvider.TextureSprite(spriteloader$preparations.missing(), true, 1.0f);
        this.leafTypeProvider.getLeafTypes().forEach((key, leafType) -> {
            ArrayList<ColoredSpriteProvider.TextureSprite> list = new ArrayList<ColoredSpriteProvider.TextureSprite>();
            for (LeafType.Texture texture : leafType.textures()) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteloader$preparations.regions().get(texture.texture());
                if (sprite != null) {
                    list.add(new ColoredSpriteProvider.TextureSprite(sprite, texture.isTinted(), texture.sizeModifier()));
                    continue;
                }
                list.add(notFound);
                LOGGER.warn("Missing leaves particle texture: {}", (Object)texture);
            }
            ColoredSpriteProvider spriteSet = new ColoredSpriteProvider(list);
            LeafType.LoadedLeafType settings = new LeafType.LoadedLeafType((LeafType)leafType, spriteSet);
            spriteSets.put(key, settings);
        });
        this.leafSettingProvider.getLeafSettings().forEach((key, leafSetting) -> {
            LeafType.LoadedLeafType loadedLeafType = (LeafType.LoadedLeafType)spriteSets.get(leafSetting.leafType());
            if (loadedLeafType == null) {
                LOGGER.warn("Missing leaf type {} for leaf setting {}", (Object)leafSetting.leafType(), key);
            } else {
                leafSprites.put(key, new LeafSetting.LoadedLeafSetting((LeafSetting)leafSetting, loadedLeafType));
            }
        });
        this.loadedLeaves = Collections.unmodifiableMap(spriteSets);
        this.loadedSettings = Collections.unmodifiableMap(leafSprites);
    }
}

