/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data.generator;

import de.cheaterpaul.fallingleaves.FallingLeavesMod;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafType;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafTypes;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LeafTypeGenerator
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> holderLookup;

    public LeafTypeGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> holderLookup) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "fallingleaves/leaftypes");
        this.holderLookup = holderLookup;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        return this.holderLookup.thenCompose(holder -> {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            BiConsumer<ResourceLocation, LeafType> consumer = (id, entry) -> {
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate leaf type entry " + String.valueOf(id));
                }
                Path path = this.pathProvider.json(id);
                list.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)holder, LeafType.CODEC, (Object)entry, (Path)path));
            };
            this.registerLeafTypes(consumer);
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    @NotNull
    public String getName() {
        return "leave type generator";
    }

    protected void registerLeafTypes(BiConsumer<ResourceLocation, LeafType> consumer) {
        consumer.accept(LeafTypes.DEFAULT, new LeafType(1.0f, 1.0f, 1.0f, FallingLeavesMod.modId("default_1"), FallingLeavesMod.modId("default_2"), FallingLeavesMod.modId("default_3"), FallingLeavesMod.modId("default_4"), FallingLeavesMod.modId("default_5")));
        consumer.accept(LeafTypes.CONIFER, new LeafType(0.2f, 1.0f, 1.5f, new LeafType.SeasonModifier(new LeafType.Season(1.0f), new LeafType.Season(1.0f), new LeafType.Season(1.0f), new LeafType.Season(1.0f)), FallingLeavesMod.modId("conifer_1"), FallingLeavesMod.modId("conifer_2"), FallingLeavesMod.modId("conifer_3")));
        consumer.accept(LeafTypes.PALMS, new LeafType(0.5f, 4.0f, 2.0f, FallingLeavesMod.modId("palms_1"), FallingLeavesMod.modId("palms_2")));
        consumer.accept(LeafTypes.MAHOGANY, new LeafType(1.0f, 1.0f, 1.0f, FallingLeavesMod.modId("mahogany_1"), FallingLeavesMod.modId("mahogany_2")));
        consumer.accept(LeafTypes.MAPLE, new LeafType(1.0f, 1.0f, 1.0f, FallingLeavesMod.modId("maple_1"), FallingLeavesMod.modId("maple_1")));
        consumer.accept(LeafTypes.CHERRY, new LeafType(1.3f, 1.0f, 1.0f, new LeafType.SeasonModifier(new LeafType.Season(0.2f, 0.5f, 1.2f), new LeafType.Season(0.8f, 0.4f, 0.0f), new LeafType.Season(0.0f), new LeafType.Season(0.0f)), new LeafType.Texture(FallingLeavesMod.modId("cherry_flower_1"), true, 2.0f), new LeafType.Texture(FallingLeavesMod.modId("cherry_flower_1"), true, 2.0f), new LeafType.Texture(FallingLeavesMod.modId("cherry_1"), true)));
        consumer.accept(LeafTypes.AZALEA, new LeafType(1.3f, 1.0f, 1.0f, new LeafType.SeasonModifier(new LeafType.Season(0.2f, 0.5f, 1.2f), new LeafType.Season(0.8f, 0.4f, 0.0f), new LeafType.Season(0.0f), new LeafType.Season(0.0f)), new LeafType.Texture(FallingLeavesMod.modId("azalea_flower_1"), true, 2.0f)));
    }
}

