/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import de.cheaterpaul.fallingleaves.data.generator.LeafSettingGenerator;
import de.cheaterpaul.fallingleaves.data.generator.LeafTypeGenerator;
import de.cheaterpaul.fallingleaves.data.provider.LeafProvider;
import de.cheaterpaul.fallingleaves.leaves.mod.types.LeafSetting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="fallingleaves", value={Dist.CLIENT})
public class LeafLoader {
    private static LeafProvider LEAF_PROVIDER;
    public static final ResourceLocation DEFAULT_SETTINGS;

    @SubscribeEvent
    public static void registerReloadListener(AddClientReloadListenersEvent event) {
        LEAF_PROVIDER = new LeafProvider();
        event.addListener(LeafProvider.LEAF_LISTENER, (PreparableReloadListener)LEAF_PROVIDER);
    }

    public static LeafSetting.LoadedLeafSetting getDefault() {
        return LEAF_PROVIDER.getLoadedSettings().get(DEFAULT_SETTINGS);
    }

    public static LeafSetting.LoadedLeafSetting get(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        return LEAF_PROVIDER.getLoadedSettings().get(key);
    }

    public static LeafSetting.LoadedLeafSetting getOrDefault(Block block) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (LEAF_PROVIDER.getLoadedSettings().containsKey(key)) {
            return LEAF_PROVIDER.getLoadedSettings().get(key);
        }
        return LeafLoader.getDefault();
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent.Client event) {
        event.getGenerator().addProvider(true, (DataProvider)new LeafSettingGenerator(event.getGenerator().getPackOutput(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new LeafTypeGenerator(event.getGenerator().getPackOutput(), event.getLookupProvider()));
    }

    static {
        DEFAULT_SETTINGS = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"oak_leaves");
    }
}

