/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Wind {
    public final ModConfigSpec.BooleanValue enabled;
    private final ModConfigSpec.ConfigValue<List<? extends String>> windlessDimensions;
    private Set<ResourceLocation> windlessDimensionsSet = Set.of();

    public Wind(ModConfigSpec.Builder builder) {
        this.enabled = builder.comment("Whether to enable the wind").translation("fallingleaves.configuration.wind.enabled").define("enabled", true);
        this.windlessDimensions = builder.comment("The dimension to disable the wind in").translation("fallingleaves.configuration.wind.windlessDimensions").defineListAllowEmpty("windlessDimension", List.of(Level.NETHER.location().toString(), Level.END.location().toString()), () -> "", Wind::validateDimension);
    }

    public boolean hasWind(Level level) {
        return (Boolean)this.enabled.get() != false && !this.windlessDimensionsSet.contains(level.dimension().location());
    }

    private static boolean validateDimension(Object o) {
        String dimName;
        ResourceLocation id;
        if (o instanceof String && (id = ResourceLocation.tryParse((String)(dimName = (String)o))) != null) {
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                return ServerLifecycleHooks.getCurrentServer().registryAccess().lookupOrThrow(Registries.DIMENSION).containsKey(id);
            }
            return true;
        }
        return false;
    }

    public void onLoad(ModConfigEvent event) {
        this.windlessDimensionsSet = ((List)this.windlessDimensions.get()).stream().map(ResourceLocation::parse).collect(Collectors.toSet());
    }
}

