/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemFlightAnimator;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;

public record SyncItemTransfersPayload(Map<Vec3, ItemStack> itemsTransferred, boolean fromPlayer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncItemTransfersPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("sync_item_transfers"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncItemTransfersPayload> STREAM_CODEC = StreamCodec.composite(StreamCodecHelper.ofMap(StreamCodecHelper.VEC3, ItemStack.STREAM_CODEC, HashMap::new), SyncItemTransfersPayload::itemsTransferred, (StreamCodec)ByteBufCodecs.BOOL, SyncItemTransfersPayload::fromPlayer, SyncItemTransfersPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(SyncItemTransfersPayload payload, IPayloadContext context) {
        payload.itemsTransferred().forEach((pos, stack) -> {
            Player player = context.player();
            Vec3 playerPos = player.getEyePosition().add(0.0, -0.1, 0.0);
            Vec3 from = payload.fromPlayer() ? playerPos : pos;
            Vec3 to = payload.fromPlayer() ? pos : playerPos;
            Level level = player.level();
            ItemFlightAnimator.startFlight(stack, from, to, level.getGameTime(), 10, level.getRandom());
            level.playSound((Entity)player, to.x(), to.y(), to.z(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, RandHelper.getRandomMinusOneToOne(level.random) * 1.4f + 2.0f);
        });
    }
}

