/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SyncItemHighlightsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public record RequestItemHighlightsPayload(ItemStack stack, List<BlockPos> storagePositions, Map<ResourceLocation, Object> extras) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestItemHighlightsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("request_item_highlights"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestItemHighlightsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RequestItemHighlightsPayload::stack, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), RequestItemHighlightsPayload::storagePositions, ItemActionHandlerRegistry.EXTRAS_STREAM_CODEC, RequestItemHighlightsPayload::extras, RequestItemHighlightsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RequestItemHighlightsPayload payload, IPayloadContext context) {
        ItemStackKey stackKey = ItemStackKey.of(payload.stack());
        Player player = context.player();
        Level level = player.level();
        AtomicInteger stackMatchNumber = new AtomicInteger(0);
        AtomicInteger itemMatchNumber = new AtomicInteger(0);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ArrayList<BlockPos> stackPositions = new ArrayList<BlockPos>();
            ArrayList<BlockPos> itemPositions = new ArrayList<BlockPos>();
            payload.storagePositions().forEach(pos -> WorldHelper.getLoadedBlockEntity(level, pos, IControllableStorage.class).ifPresent(storage -> {
                ISlotTracker slotTracker = storage.getStorageWrapper().getInventoryHandler().getSlotTracker();
                if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                    stackPositions.add((BlockPos)pos);
                } else if (slotTracker.getItems().contains(payload.stack().getItem())) {
                    itemPositions.add((BlockPos)pos);
                }
            }));
            stackMatchNumber.addAndGet(stackPositions.size());
            itemMatchNumber.addAndGet(itemPositions.size());
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncItemHighlightsPayload(stackPositions, itemPositions, List.of()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            payload.extras().forEach((id, extra) -> ItemActionHandlerRegistry.get(id).ifPresent(h -> {
                IItemActionPayloadHandler.HighlightResult result = RequestItemHighlightsPayload.compute(h, serverPlayer, stackKey, extra);
                stackMatchNumber.addAndGet(result.stackCounts());
                itemMatchNumber.addAndGet(result.itemCounts());
            }));
            MutableComponent message = null;
            if (stackMatchNumber.get() == 0 && itemMatchNumber.get() == 0) {
                message = Component.translatable((String)"gui.sophisticatedcore.status.no_matching_items_found");
            } else {
                if (stackMatchNumber.get() > 0) {
                    message = Component.translatable((String)"gui.sophisticatedcore.status.matching_stacks_found", (Object[])new Object[]{Component.literal((String)String.valueOf(stackMatchNumber.get())).withColor(5025616)});
                }
                if (itemMatchNumber.get() > 0) {
                    MutableComponent itemMessage = Component.translatable((String)"gui.sophisticatedcore.status.matching_items_found", (Object[])new Object[]{Component.literal((String)String.valueOf(itemMatchNumber.get())).withColor(4367861)});
                    message = message != null ? message.plainCopy().append(" ").append((Component)itemMessage) : itemMessage;
                }
            }
            player.displayClientMessage((Component)message, true);
        }
    }

    private static <T> IItemActionPayloadHandler.HighlightResult compute(IItemActionPayloadHandler<T> handler, ServerPlayer serverPlayer, ItemStackKey stackKey, Object extra) {
        return handler.computeHighlight(serverPlayer, stackKey, extra);
    }
}

