/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.block.entity.OnLoadHandler;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.api.event.WaystoneInitializedEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.component.WaystoneReferenceComponent;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneVisibilities;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.WaystoneEditMenu;
import net.blay09.mods.waystones.menu.WaystoneModifierMenu;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class WaystoneBlockEntityBase
extends BalmBlockEntity
implements OnLoadHandler,
CustomRenderBoundingBox,
BalmContainerProvider {
    protected final DefaultContainer container = new DefaultContainer(5){

        public int getMaxStackSize(ItemStack itemStack) {
            if (itemStack.is(ModItems.dormantShard)) {
                return 1;
            }
            return super.getMaxStackSize(itemStack);
        }

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (itemStack.is(ModItems.dormantShard)) {
                return slot == 0;
            }
            return super.canPlaceItem(slot, itemStack);
        }

        public void setChanged() {
            WaystoneBlockEntityBase.this.onInventoryChanged();
        }

        public boolean stillValid(Player player) {
            return Container.stillValidBlockEntity((BlockEntity)WaystoneBlockEntityBase.this, (Player)player);
        }
    };
    private Waystone waystone = InvalidWaystone.INSTANCE;
    private UUID waystoneUid;
    private boolean shouldNotInitialize;
    private boolean silkTouched;

    protected void onInventoryChanged() {
    }

    public WaystoneBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output, (NonNullList)this.container.getItems());
        output.storeNullable("UUID", UUIDUtil.CODEC, (Object)this.getEffectiveWaystoneUid());
    }

    public void loadAdditional(ValueInput input) {
        ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)this.container.getItems());
        input.read("UUID", UUIDUtil.CODEC).ifPresent(uuid -> {
            this.waystoneUid = uuid;
        });
        input.read("Waystone", WaystoneImpl.CODEC.codec()).ifPresent(loadedWaystone -> {
            this.waystone = loadedWaystone;
        });
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        UUID waystoneUidFromComponent = Optional.ofNullable((WaystoneReferenceComponent)input.get((DataComponentType)ModComponents.waystoneIdentity.get())).map(WaystoneReferenceComponent::waystoneId).orElseGet(() -> (UUID)input.get((DataComponentType)ModComponents.waystone.get()));
        if (waystoneUidFromComponent != null) {
            this.waystoneUid = waystoneUidFromComponent;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set((DataComponentType)ModComponents.waystoneIdentity.get(), (Object)new WaystoneReferenceComponent(this.getEffectiveWaystoneUid(), this.waystone.getName()));
    }

    public void writeUpdateTag(ValueOutput output) {
        output.store("Waystone", WaystoneImpl.CODEC.codec(), (Object)this.getWaystone());
    }

    public void onLoad() {
        Waystone backingWaystone = this.waystone;
        if (this.waystone instanceof WaystoneProxy) {
            backingWaystone = ((WaystoneProxy)this.waystone).getBackingWaystone();
        }
        if (backingWaystone instanceof WaystoneImpl && this.level != null) {
            ((WaystoneImpl)backingWaystone).setDimension((ResourceKey<Level>)this.level.dimension());
            ((WaystoneImpl)backingWaystone).setPos(this.worldPosition);
        }
        this.sync();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)(this.worldPosition.getX() + 1), (double)(this.worldPosition.getY() + 2), (double)(this.worldPosition.getZ() + 1));
    }

    public Waystone getWaystone() {
        if (!(this.waystone.isValid() || this.level == null || this.level.isClientSide || this.shouldNotInitialize)) {
            BlockState state;
            if (this.waystoneUid != null) {
                this.waystone = new WaystoneProxy(this.level.getServer(), this.waystoneUid);
            }
            if (!this.waystone.isValid() && (state = this.getBlockState()).getBlock() instanceof WaystoneBlockBase) {
                BlockEntity blockEntity;
                WaystoneOrigin origin;
                DoubleBlockHalf half = state.hasProperty(WaystoneBlockBase.HALF) ? (DoubleBlockHalf)state.getValue(WaystoneBlockBase.HALF) : DoubleBlockHalf.LOWER;
                WaystoneOrigin waystoneOrigin = origin = state.hasProperty(WaystoneBlockBase.ORIGIN) ? (WaystoneOrigin)((Object)state.getValue(WaystoneBlockBase.ORIGIN)) : WaystoneOrigin.UNKNOWN;
                if (half == DoubleBlockHalf.LOWER) {
                    this.initializeWaystone((ServerLevelAccessor)Objects.requireNonNull(this.level), null, origin);
                } else if (half == DoubleBlockHalf.UPPER && (blockEntity = this.level.getBlockEntity(this.worldPosition.below())) instanceof WaystoneBlockEntityBase) {
                    this.initializeFromBase((WaystoneBlockEntityBase)blockEntity);
                }
            }
            if (this.waystone.isValid()) {
                this.waystoneUid = this.waystone.getWaystoneUid();
                this.sync();
            }
        }
        return this.waystone;
    }

    protected abstract ResourceLocation getWaystoneType();

    public void initializeWaystone(ServerLevelAccessor level, @Nullable LivingEntity player, WaystoneOrigin origin) {
        WaystoneImpl waystone = new WaystoneImpl(this.getWaystoneType(), UUID.randomUUID(), (ResourceKey<Level>)level.getLevel().dimension(), this.worldPosition, origin, player != null ? player.getUUID() : null);
        SavedDataWaystonesStore.get(level.getLevel().getServer()).addWaystone(waystone);
        Balm.getEvents().fireEvent((Object)new WaystoneInitializedEvent(waystone));
        this.waystone = waystone;
        this.setChanged();
        this.sync();
    }

    public void initializeFromExisting(ServerLevelAccessor level, WaystoneImpl existingWaystone, ItemStack itemStack) {
        this.waystone = existingWaystone;
        existingWaystone.setDimension((ResourceKey<Level>)level.getLevel().dimension());
        existingWaystone.setPos(this.worldPosition);
        existingWaystone.setTransient(false);
        SavedDataWaystonesStore.get(level.getLevel().getServer()).updateWaystone(this.waystone);
        this.setChanged();
        this.sync();
    }

    public void initializeFromBase(WaystoneBlockEntityBase tileEntity) {
        this.waystone = tileEntity.getWaystone();
        this.setChanged();
        this.sync();
    }

    public void uninitializeWaystone() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.waystone.isValid()) {
                MinecraftServer server = serverLevel.getServer();
                SavedDataWaystonesStore.get(server).removeWaystone(this.waystone);
                PlayerWaystoneManager.removeKnownWaystone(server, this.waystone);
                WaystoneSyncManager.sendWaystoneRemovalToAll(server, this.waystone, true);
            }
            this.waystone = InvalidWaystone.INSTANCE;
            this.shouldNotInitialize = true;
            DoubleBlockHalf half = (DoubleBlockHalf)this.getBlockState().getValue((Property)WaystoneBlock.HALF);
            BlockPos otherPos = half == DoubleBlockHalf.UPPER ? this.worldPosition.below() : this.worldPosition.above();
            BlockEntity blockEntity = Objects.requireNonNull(this.level).getBlockEntity(otherPos);
            if (blockEntity instanceof WaystoneBlockEntityBase) {
                WaystoneBlockEntityBase waystoneTile = (WaystoneBlockEntityBase)blockEntity;
                waystoneTile.waystone = InvalidWaystone.INSTANCE;
                waystoneTile.shouldNotInitialize = true;
            }
            this.setChanged();
            this.sync();
        }
    }

    public void setSilkTouched(boolean silkTouched) {
        this.silkTouched = silkTouched;
    }

    public boolean canSilkTouch() {
        return false;
    }

    public boolean isSilkTouched() {
        return this.silkTouched;
    }

    public Optional<MenuProvider> getSelectionMenuProvider() {
        return Optional.empty();
    }

    public abstract Component getName();

    public Optional<MenuProvider> getSettingsMenuProvider() {
        return Optional.of(new BalmMenuProvider<WaystoneEditMenu.Data>(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.waystones.waystone_settings", (Object[])new Object[]{WaystoneBlockEntityBase.this.getName()});
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((ServerPlayer)player, WaystoneBlockEntityBase.this.getWaystone());
                List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions((ServerPlayer)player, WaystoneBlockEntityBase.this.waystone);
                return new WaystoneEditMenu(i, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(Component::translatable).orElse(null), visibilityOptions, WaystoneBlockEntityBase.this.getContainer());
            }

            public WaystoneEditMenu.Data getScreenOpeningData(ServerPlayer player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, WaystoneBlockEntityBase.this.getWaystone());
                List<WaystoneVisibility> visibilityOptions = WaystoneVisibilities.getVisibilityOptions(player, WaystoneBlockEntityBase.this.waystone);
                return new WaystoneEditMenu.Data(WaystoneBlockEntityBase.this.worldPosition, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getModifierCount(), error.map(WaystoneEditError::getTranslationKey).map(Component::translatable), visibilityOptions);
            }

            public StreamCodec<RegistryFriendlyByteBuf, WaystoneEditMenu.Data> getScreenStreamCodec() {
                return WaystoneEditMenu.STREAM_CODEC;
            }
        });
    }

    public Optional<MenuProvider> getModifierMenuProvider() {
        return Optional.of(new BalmMenuProvider<Waystone>(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.waystones.waystone_modifiers");
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                return new WaystoneModifierMenu(i, playerInventory, WaystoneBlockEntityBase.this.getWaystone(), WaystoneBlockEntityBase.this.getContainer());
            }

            public Waystone getScreenOpeningData(ServerPlayer serverPlayer) {
                return WaystoneBlockEntityBase.this.getWaystone();
            }

            public StreamCodec<RegistryFriendlyByteBuf, Waystone> getScreenStreamCodec() {
                return WaystoneImpl.STREAM_CODEC;
            }
        });
    }

    public Collection<? extends Waystone> getAuxiliaryTargets() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack item = this.container.getItem(i);
            WaystonesAPI.getBoundWaystone(null, item).ifPresent(result::add);
        }
        return result;
    }

    public Container getContainer() {
        return this.container;
    }

    public void applyModifierEffects(Entity entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<ItemStack> curativeItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack itemStack = this.container.getItem(i);
            if (itemStack.getItem() == Items.BLAZE_POWDER) {
                fireSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.POISONOUS_POTATO) {
                poisonSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.INK_SAC) {
                blindSeconds += itemStack.getCount();
                continue;
            }
            if (itemStack.getItem() == Items.MILK_BUCKET || itemStack.getItem() == Items.HONEY_BLOCK) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.getItem() == Items.DIAMOND) {
                potency = Math.min(4, potency + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() == Items.FEATHER) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() == Items.MAGMA_CREAM) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.getCount());
                continue;
            }
            if (itemStack.getItem() != Items.WITHER_ROSE) continue;
            witherSeconds += itemStack.getCount();
        }
        if (entity instanceof LivingEntity) {
            if (fireSeconds > 0) {
                entity.setRemainingFireTicks(fireSeconds * 20);
            }
            if (poisonSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.WITHER, witherSeconds * 20, potency));
            }
            for (ItemStack curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((LivingEntity)entity, curativeItem);
            }
        }
    }

    private int getModifierCount() {
        int modifiers = 0;
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack itemStack = this.container.getItem(i);
            if (itemStack.getItem() == Items.BLAZE_POWDER) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.POISONOUS_POTATO) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.INK_SAC) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.MILK_BUCKET || itemStack.getItem() == Items.HONEY_BLOCK) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.DIAMOND) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.FEATHER) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.MAGMA_CREAM) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.WITHER_ROSE) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() == Items.QUARTZ) {
                ++modifiers;
                continue;
            }
            if (itemStack.getItem() != Items.SPIDER_EYE) continue;
            ++modifiers;
        }
        return modifiers;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Waystone waystone = this.getWaystone();
            boolean wasNotSilkTouched = !this.canSilkTouch() || !this.isSilkTouched();
            WaystoneSyncManager.sendWaystoneRemovalToAll(serverLevel.getServer(), waystone, wasNotSilkTouched);
            if (wasNotSilkTouched) {
                SavedDataWaystonesStore.get(serverLevel.getServer()).removeWaystone(waystone);
                PlayerWaystoneManager.removeKnownWaystone(serverLevel.getServer(), waystone);
            } else if (waystone instanceof MutableWaystone) {
                MutableWaystone mutableWaystone = (MutableWaystone)((Object)waystone);
                mutableWaystone.setTransient(true);
                SavedDataWaystonesStore.get(serverLevel.getServer()).updateWaystone(waystone);
            }
        }
    }

    protected UUID getEffectiveWaystoneUid() {
        return this.waystone.isValid() ? this.waystone.getWaystoneUid() : this.waystoneUid;
    }
}

