/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlock
extends WaystoneBlockBase {
    public static final MapCodec<WarpPlateBlock> CODEC = WarpPlateBlock.simpleCodec(WarpPlateBlock::new);
    private static final Style GALACTIC_STYLE = Style.EMPTY.withFont(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"alt"));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)WarpPlateBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)WarpPlateBlock.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)).optimize();
    public static final EnumProperty<WarpPlateStatus> STATUS = EnumProperty.create((String)"status", WarpPlateStatus.class);

    public static int getColorForBlock(@Nullable BlockAndTintGetter view, BlockPos pos) {
        BlockEntity blockEntity;
        if (view == null || !((blockEntity = view.getBlockEntity(pos)) instanceof WarpPlateBlockEntity)) {
            return -1;
        }
        WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)blockEntity;
        String name = WarpPlateBlock.getGalacticIdentifier(warpPlate.getWaystone().getWaystoneUid());
        Integer color = WarpPlateBlock.getColorForName(name).getColor();
        return color != null ? color : -1;
    }

    public WarpPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(STATUS, (Comparable)((Object)WarpPlateStatus.EMPTY)));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STATUS});
    }

    public void entityInside(BlockState blockState, Level world, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier) {
        BlockEntity tileEntity;
        if (entity.getX() >= (double)pos.getX() && entity.getX() < (double)(pos.getX() + 1) && entity.getY() >= (double)pos.getY() && entity.getY() < (double)(pos.getY() + 1) && entity.getZ() >= (double)pos.getZ() && entity.getZ() < (double)(pos.getZ() + 1) && !world.isClientSide && (tileEntity = world.getBlockEntity(pos)) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)tileEntity).onEntityCollision(entity);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        block5: {
            int i;
            WarpPlateStatus status;
            block6: {
                block4: {
                    status = (WarpPlateStatus)((Object)state.getValue(STATUS));
                    if (status != WarpPlateStatus.WARPING) break block4;
                    for (int i2 = 0; i2 < 50; ++i2) {
                        world.addParticle((ParticleOptions)ParticleTypes.CRIMSON_SPORE, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random() * 2.0, (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
                        world.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + Math.random(), (double)pos.getY() + Math.random() * 2.0, (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
                    }
                    break block5;
                }
                if (status != WarpPlateStatus.WARPING_INVALID) break block6;
                for (int i3 = 0; i3 < 10; ++i3) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + Math.random(), (double)pos.getY(), (double)pos.getZ() + Math.random(), 0.0, (double)0.01f, 0.0);
                }
                break block5;
            }
            if (status != WarpPlateStatus.ATTUNING) break block5;
            for (i = 0; i < 10; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.WARPED_SPORE, (double)pos.getX() + Math.random(), (double)pos.getY(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 10; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, (double)pos.getX() + Math.random(), (double)pos.getY(), (double)pos.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WarpPlateBlockEntity(pos, state);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.is(ModItemTags.WARP_SHARDS)) {
            WarpPlateBlockEntity warpPlate;
            ItemStack existing;
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof WarpPlateBlockEntity && (existing = (warpPlate = (WarpPlateBlockEntity)blockEntity).getShardItem()).isEmpty()) {
                warpPlate.setShardItem(player.getAbilities().instabuild ? itemStack.copy().split(1) : itemStack.split(1));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (player.isShiftKeyDown()) {
            WarpPlateBlockEntity warpPlate;
            ItemStack itemStack;
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof WarpPlateBlockEntity && !(itemStack = (warpPlate = (WarpPlateBlockEntity)blockEntity).getShardItem()).isEmpty()) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
                level.addFreshEntity((Entity)itemEntity);
                warpPlate.setShardItem(ItemStack.EMPTY);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)blockEntity;
            warpPlate.getSettingsMenuProvider().ifPresent(it -> Balm.getNetworking().openMenu(player, it));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static ChatFormatting getColorForName(String name) {
        int colorIndex = Math.abs(name.hashCode()) % 15;
        ChatFormatting textFormatting = ChatFormatting.getById((int)colorIndex);
        if (textFormatting == ChatFormatting.GRAY) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (textFormatting == ChatFormatting.DARK_GRAY) {
            return ChatFormatting.DARK_PURPLE;
        }
        if (textFormatting == ChatFormatting.BLACK) {
            return ChatFormatting.GOLD;
        }
        return textFormatting != null ? textFormatting : ChatFormatting.GRAY;
    }

    public static String getGalacticIdentifier(UUID waystoneUid) {
        String intermediate = waystoneUid.toString().replaceAll("[0-9\\-]", "");
        return intermediate.substring(0, Math.min(8, intermediate.length()));
    }

    public static Component getGalacticName(UUID waystoneUid) {
        String name = WarpPlateBlock.getGalacticIdentifier(waystoneUid);
        return Component.literal((String)name).withStyle(WarpPlateBlock.getColorForName(name)).withStyle(GALACTIC_STYLE);
    }

    @Override
    protected boolean shouldOpenMenuWhenPlaced() {
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        BlockEntityType tickingBlockEntityType = (BlockEntityType)ModBlockEntities.warpPlate.get();
        if (tickingBlockEntityType == null) {
            return null;
        }
        return world.isClientSide ? null : WarpPlateBlock.createTickerHelper(type, (BlockEntityType)tickingBlockEntityType, (level, pos, state2, blockEntity) -> blockEntity.serverTick());
    }

    public static enum WarpPlateStatus implements StringRepresentable
    {
        EMPTY,
        IDLE,
        ATTUNING,
        WARPING,
        WARPING_INVALID,
        LOCKED;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

