/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconToggleButton {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private AbstractContainerMenu parentContainer;

    public static RecipeTransferButton create(IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose, @Nullable AbstractContainerMenu container, @Nullable Player player) {
        Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
        Rect2i layoutArea = recipeLayout.getRect();
        buttonArea.setX(buttonArea.getX() + layoutArea.getX());
        buttonArea.setY(buttonArea.getY() + layoutArea.getY());
        Textures textures = Internal.getTextures();
        IDrawableStatic icon = textures.getRecipeTransfer();
        RecipeTransferButton transferButton = new RecipeTransferButton(icon, recipeLayout, onClose);
        transferButton.updateBounds(buttonArea);
        transferButton.update(container, player);
        return transferButton;
    }

    private RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        super(icon, icon);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(@Nullable AbstractContainerMenu parentContainer, @Nullable Player player) {
        this.parentContainer = parentContainer;
        if (parentContainer != null && player != null) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, parentContainer, this.recipeLayout, player).orElse(null);
        } else {
            this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
        }
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.button.active = true;
            this.button.visible = true;
        } else {
            this.button.active = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.button.visible = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!input.isSimulate()) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            boolean maxTransfer = Screen.hasShiftDown();
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (this.parentContainer != null && player != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, this.parentContainer, this.recipeLayout, (Player)player, maxTransfer)) {
                this.onClose.run();
            }
        }
        return true;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.recipeTransferError == null) {
            MutableComponent tooltipTransfer = Component.translatable((String)"jei.tooltip.transfer");
            tooltip.add((FormattedText)tooltipTransfer);
        } else {
            this.recipeTransferError.getTooltip(tooltip);
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return false;
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.draw(guiGraphics, mouseX, mouseY, partialTicks);
        IRecipeTransferError recipeTransferError = this.recipeTransferError;
        if (recipeTransferError != null) {
            if (recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
                guiGraphics.fill(this.button.getX(), this.button.getY(), this.button.getX() + this.button.getWidth(), this.button.getY() + this.button.getHeight(), recipeTransferError.getButtonHighlightColor());
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                Rect2i recipeRect = this.recipeLayout.getRect();
                recipeTransferError.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeRect.getX(), recipeRect.getY());
            }
        }
    }

    public int getMissingCountHint() {
        if (this.recipeTransferError == null) {
            return 0;
        }
        return this.recipeTransferError.getMissingCountHint();
    }
}

