/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.rechiseled.api.ChiselingRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class CGChiselingRecipeProvider
extends ChiselingRecipeProvider {
    public CGChiselingRecipeProvider(DataGenerator generator) {
        super("connectedglass", generator);
    }

    protected void buildRecipes() {
        this.beginRecipe("glass").add(Items.GLASS, CGGlassType.BORDERLESS_GLASS.block.asItem()).addConnectingItem(CGGlassType.CLEAR_GLASS.block.asItem()).addConnectingItem(CGGlassType.SCRATCHED_GLASS.block.asItem());
        this.beginRecipe("glass_pane").add(Items.GLASS_PANE, CGGlassType.BORDERLESS_GLASS.pane.asItem()).addConnectingItem(CGGlassType.CLEAR_GLASS.pane.asItem()).addConnectingItem(CGGlassType.SCRATCHED_GLASS.pane.asItem());
        for (DyeColor color : DyeColor.values()) {
            ChiselingRecipeProvider.ChiselingRecipeBuilder builder = this.beginRecipe(color.getName() + "_stained_glass");
            Item glass = switch (color) {
                default -> throw new MatchException(null, null);
                case DyeColor.WHITE -> Items.WHITE_STAINED_GLASS;
                case DyeColor.ORANGE -> Items.ORANGE_STAINED_GLASS;
                case DyeColor.MAGENTA -> Items.MAGENTA_STAINED_GLASS;
                case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_STAINED_GLASS;
                case DyeColor.YELLOW -> Items.YELLOW_STAINED_GLASS;
                case DyeColor.LIME -> Items.LIME_STAINED_GLASS;
                case DyeColor.PINK -> Items.PINK_STAINED_GLASS;
                case DyeColor.GRAY -> Items.GRAY_STAINED_GLASS;
                case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_STAINED_GLASS;
                case DyeColor.CYAN -> Items.CYAN_STAINED_GLASS;
                case DyeColor.PURPLE -> Items.PURPLE_STAINED_GLASS;
                case DyeColor.BLUE -> Items.BLUE_STAINED_GLASS;
                case DyeColor.BROWN -> Items.BROWN_STAINED_GLASS;
                case DyeColor.GREEN -> Items.GREEN_STAINED_GLASS;
                case DyeColor.RED -> Items.RED_STAINED_GLASS;
                case DyeColor.BLACK -> Items.BLACK_STAINED_GLASS;
            };
            builder.add(glass, CGGlassType.BORDERLESS_GLASS.getBlock(color).asItem());
            builder.addConnectingItem(CGGlassType.CLEAR_GLASS.getBlock(color).asItem());
            builder.addConnectingItem(CGGlassType.SCRATCHED_GLASS.getBlock(color).asItem());
            ChiselingRecipeProvider.ChiselingRecipeBuilder paneBuilder = this.beginRecipe(color.getName() + "_stained_glass_pane");
            Item pane = switch (color) {
                default -> throw new MatchException(null, null);
                case DyeColor.WHITE -> Items.WHITE_STAINED_GLASS_PANE;
                case DyeColor.ORANGE -> Items.ORANGE_STAINED_GLASS_PANE;
                case DyeColor.MAGENTA -> Items.MAGENTA_STAINED_GLASS_PANE;
                case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_STAINED_GLASS_PANE;
                case DyeColor.YELLOW -> Items.YELLOW_STAINED_GLASS_PANE;
                case DyeColor.LIME -> Items.LIME_STAINED_GLASS_PANE;
                case DyeColor.PINK -> Items.PINK_STAINED_GLASS_PANE;
                case DyeColor.GRAY -> Items.GRAY_STAINED_GLASS_PANE;
                case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_STAINED_GLASS_PANE;
                case DyeColor.CYAN -> Items.CYAN_STAINED_GLASS_PANE;
                case DyeColor.PURPLE -> Items.PURPLE_STAINED_GLASS_PANE;
                case DyeColor.BLUE -> Items.BLUE_STAINED_GLASS_PANE;
                case DyeColor.BROWN -> Items.BROWN_STAINED_GLASS_PANE;
                case DyeColor.GREEN -> Items.GREEN_STAINED_GLASS_PANE;
                case DyeColor.RED -> Items.RED_STAINED_GLASS_PANE;
                case DyeColor.BLACK -> Items.BLACK_STAINED_GLASS_PANE;
            };
            paneBuilder.add(pane, CGGlassType.BORDERLESS_GLASS.getPane(color).asItem());
            paneBuilder.addConnectingItem(CGGlassType.CLEAR_GLASS.getPane(color).asItem());
            paneBuilder.addConnectingItem(CGGlassType.SCRATCHED_GLASS.getPane(color).asItem());
        }
        ChiselingRecipeProvider.ChiselingRecipeBuilder builder = this.beginRecipe("tinted_glass");
        builder.add(Items.TINTED_GLASS, CGGlassType.TINTED_BORDERLESS_GLASS.block.asItem());
        CGGlassType.TINTED_BORDERLESS_GLASS.colored_blocks.values().forEach(block -> builder.addConnectingItem(block.asItem()));
    }
}

