/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrShulkerBlockEntity
extends RandomizableContainerBlockEntity
implements ILootrBlockEntity {
    private final NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    protected UUID infoId;
    protected boolean hasBeenOpened = false;
    private String cachedId;
    private final Set<UUID> clientOpeners = new ObjectLinkedOpenHashSet();
    protected boolean clientOpened;
    private int openCount;
    private ShulkerBoxBlockEntity.AnimationStatus animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;

    public LootrShulkerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(LootrRegistry.getShulkerBlockEntity(), pWorldPosition, pBlockState);
    }

    @Override
    public void defaultTick(Level level, BlockPos pos, BlockState state) {
        ILootrBlockEntity.super.defaultTick(level, pos, state);
        this.updateAnimation(level, pos, state);
    }

    private static void doNeighborUpdates(Level pLevel, BlockPos pPos, BlockState pState) {
        pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 3);
        pLevel.updateNeighborsAt(pPos, pState.getBlock());
    }

    private void updateAnimation(Level pLevel, BlockPos pPos, BlockState pState) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progressOld == 0.0f) {
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                if (this.progress >= 1.0f) {
                    this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                this.moveCollidedEntities(pLevel, pPos, pState);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (this.progressOld == 1.0f) {
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
            }
        }
    }

    public ShulkerBoxBlockEntity.AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState pState) {
        Vec3 vec3 = new Vec3(0.5, 0.0, 0.5);
        return Shulker.getProgressAabb((float)1.0f, (Direction)((Direction)pState.getValue((Property)ShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)), (Vec3)vec3);
    }

    private void moveCollidedEntities(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pState.getBlock() instanceof ShulkerBoxBlock) {
            Direction direction = (Direction)pState.getValue((Property)ShulkerBoxBlock.FACING);
            AABB aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)direction, (float)this.progressOld, (float)this.progress, (Vec3)this.getBlockPos().getBottomCenter());
            List list = pLevel.getEntities(null, aabb);
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3((aabb.getXsize() + 0.01) * (double)direction.getStepX(), (aabb.getYsize() + 0.01) * (double)direction.getStepY(), (aabb.getZsize() + 0.01) * (double)direction.getStepZ()));
            }
        }
    }

    public int getContainerSize() {
        return 27;
    }

    public boolean triggerEvent(int pEvent, int pCount) {
        if (pEvent == 1) {
            this.openCount = pCount;
            if (pCount == 0) {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSING;
            }
            if (pCount == 1) {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENING;
            }
            return true;
        }
        return super.triggerEvent(pEvent, pCount);
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            if (!this.hasBeenOpened) {
                this.hasBeenOpened = true;
                this.markChanged();
            }
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount == 1) {
                this.level.gameEvent((Entity)pPlayer, (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            --this.openCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.level.gameEvent((Entity)pPlayer, (Holder)GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound(null, this.worldPosition, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.shulkerBox");
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return null;
    }

    protected void loadAdditional(ValueInput compound) {
        super.loadAdditional(compound);
        this.tryLoadLootTable(compound);
        compound.read("LootrId", UUIDUtil.CODEC).ifPresent(uuid -> {
            this.infoId = uuid;
        });
        this.hasBeenOpened = compound.getBooleanOr("LootrHasBeenOpened", false);
        if (this.infoId == null) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        compound.read("LootrOpeners", UUIDUtil.CODEC_SET).ifPresent(this.clientOpeners::addAll);
    }

    public void removeComponentsFromTag(ValueOutput compoundTag) {
        super.removeComponentsFromTag(compoundTag);
        compoundTag.discard("LootrId");
    }

    protected void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        this.trySaveLootTable(compound);
        if (!LootrAPI.shouldDiscard()) {
            compound.store("LootrId", UUIDUtil.CODEC, (Object)this.getInfoUUID());
        }
        compound.putBoolean("LootrHasBeenOpened", this.hasBeenOpened);
        if (this.level != null && this.level.isClientSide() && this.clientOpeners != null && !this.clientOpeners.isEmpty()) {
            compound.store("LootrOpeners", UUIDUtil.CODEC_SET, this.clientOpeners);
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
    }

    public float getProgress(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    @Override
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.SHULKER;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    @Override
    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return !this.isClosed();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag result = super.getUpdateTag(provider);
        Set currentOpeners = this.getVisualOpeners();
        if (currentOpeners != null) {
            result.store("LootrOpeners", UUIDUtil.CODEC_SET, (Object)Sets.intersection((Set)currentOpeners, LootrAPI.getPlayerIds()));
        }
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    @Override
    public void markChanged() {
        this.setChanged();
        this.markDataChanged();
    }

    @Override
    public boolean isClientOpened() {
        return this.clientOpened;
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return this.getBlockPos();
    }

    @Override
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.getLootTable();
    }

    @Override
    @Nullable
    public Component getInfoDisplayName() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.getLevel().dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return this.getContainerSize();
    }

    @Override
    public long getInfoLootSeed() {
        return this.getLootTableSeed();
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    public Level getInfoLevel() {
        return this.getLevel();
    }

    @Override
    public int getPhysicalOpenerCount() {
        return this.openCount;
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getShulkerTrigger();
    }

    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrShulkerBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrShulkerBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public BlockEntityType<?> getBlockEntityType() {
            return LootrRegistry.getShulkerBlockEntity();
        }
    }
}

