/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.level.saveddata.SavedData;

public class TickingData
extends SavedData {
    public static final Codec<TickingData> CODEC = TickEntry.CODEC.listOf().xmap(TickingData::new, o -> o.getTickMap().object2IntEntrySet().stream().map(entry -> new TickEntry((UUID)entry.getKey(), entry.getIntValue())).toList());
    private final Object2IntMap<UUID> tickMap = new Object2IntOpenHashMap();

    public TickingData() {
        this.tickMap.defaultReturnValue(-1);
    }

    private TickingData(SavedData.Context context) {
        this();
    }

    private TickingData(List<TickEntry> entries) {
        this();
        for (TickEntry entry : entries) {
            this.tickMap.put((Object)entry.id(), entry.value());
        }
    }

    private Object2IntMap<UUID> getTickMap() {
        return this.tickMap;
    }

    public boolean isComplete(UUID id) {
        return this.tickMap.getInt((Object)id) == 0 || this.tickMap.getInt((Object)id) == 1;
    }

    public int getValue(UUID id) {
        return this.tickMap.getInt((Object)id);
    }

    public void setValue(UUID id, int decayAmount) {
        if (this.tickMap.put((Object)id, decayAmount) == -1) {
            this.setDirty();
        }
    }

    public void remove(UUID id) {
        if (this.tickMap.removeInt((Object)id) != -1) {
            this.setDirty();
        }
    }

    public void tick() {
        if (this.tickMap.isEmpty()) {
            return;
        }
        Object2IntOpenHashMap newMap = new Object2IntOpenHashMap();
        newMap.defaultReturnValue(-1);
        boolean changed = false;
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            int value = entry.getIntValue();
            if (value > 0) {
                --value;
                changed = true;
            }
            newMap.put((Object)((UUID)entry.getKey()), value);
        }
        if (changed) {
            this.tickMap.clear();
            this.tickMap.putAll((Map)newMap);
            this.setDirty();
        }
    }

    private record TickEntry(UUID id, int value) {
        public static final Codec<TickEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(TickEntry::id), (App)Codec.INT.fieldOf("value").forGetter(TickEntry::value)).apply((Applicative)instance, TickEntry::new));
    }
}

