/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.network.message.FrameworkPayload;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.Nullable;

public class FrameworkMessage<T, B extends FriendlyByteBuf, C extends MessageContext> {
    private final CustomPacketPayload.Type<FrameworkPayload<T>> type;
    private final Class<T> messageClass;
    private final StreamCodec<B, FrameworkPayload<T>> codec;
    private final BiConsumer<T, C> handler;
    @Nullable
    private final PacketFlow flow;

    public FrameworkMessage(CustomPacketPayload.Type<FrameworkPayload<T>> type, Class<T> messageClass, StreamCodec<B, FrameworkPayload<T>> codec, BiConsumer<T, C> handler, @Nullable PacketFlow flow) {
        this.type = type;
        this.messageClass = messageClass;
        this.codec = codec;
        this.handler = handler;
        this.flow = flow;
    }

    public FrameworkPayload<T> writePayload(T msg) {
        return new FrameworkPayload<T>(this.type, msg);
    }

    public CustomPacketPayload.Type<FrameworkPayload<T>> type() {
        return this.type;
    }

    public Class<T> messageClass() {
        return this.messageClass;
    }

    public StreamCodec<B, FrameworkPayload<T>> codec() {
        return this.codec;
    }

    public BiConsumer<T, C> handler() {
        return this.handler;
    }

    @Nullable
    public PacketFlow flow() {
        return this.flow;
    }
}

