/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.model;

import com.mrcrayfish.framework.api.client.model.FrameworkModelBaker;
import com.mrcrayfish.framework.api.client.model.FrameworkModelResource;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;

public class NeoForgeModelResource<T>
extends FrameworkModelResource<T> {
    private final StandaloneModelKey<T> key = new StandaloneModelKey(() -> ((ResourceLocation)location).toString());
    private final UnbakedStandaloneModel<T> baker;

    public NeoForgeModelResource(final ResourceLocation location, final FrameworkModelBaker<T> modelBaker) {
        super(location, modelBaker);
        this.baker = new UnbakedStandaloneModel<T>(this){

            public T bake(ModelBaker baker) {
                ResolvedModel resolvedModel = baker.getModel(location);
                return modelBaker.bake(resolvedModel, baker);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                resolver.markDependency(location);
            }
        };
    }

    public StandaloneModelKey<T> standaloneKey() {
        return this.key;
    }

    public UnbakedStandaloneModel<T> unbakedModel() {
        return this.baker;
    }
}

