/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.model;

import com.mrcrayfish.framework.api.client.model.FrameworkBakedModel;
import com.mrcrayfish.framework.api.client.model.FrameworkModelBaker;
import com.mrcrayfish.framework.platform.ClientServices;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkModelResource<T> {
    private final ResourceLocation location;
    private final FrameworkModelBaker<T> baker;
    private T cachedModel;

    FrameworkModelResource(ResourceLocation location, FrameworkModelBaker<T> baker) {
        this.location = location;
        this.baker = baker;
    }

    public final ResourceLocation getLocation() {
        return this.location;
    }

    public final FrameworkModelBaker<T> getBaker() {
        return this.baker;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameworkModelResource that = (FrameworkModelResource)o;
        return this.location.equals((Object)that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Nullable
    public T getModel() {
        if (this.cachedModel == null) {
            this.cachedModel = ClientServices.CLIENT.getStandaloneModel(this);
        }
        return this.cachedModel;
    }

    public void clearCache() {
        this.cachedModel = null;
    }

    public static FrameworkModelResource<FrameworkBakedModel> create(ResourceLocation location) {
        return FrameworkModelResource.createCustom(location, FrameworkBakedModel.BAKER);
    }

    public static FrameworkModelResource<SimpleModelWrapper> createVanilla(ResourceLocation location) {
        return FrameworkModelResource.createCustom(location, (model, baker) -> SimpleModelWrapper.bake((ModelBaker)baker, (ResourceLocation)location, (ModelState)Variant.SimpleModelState.DEFAULT.asModelState()));
    }

    public static <T> FrameworkModelResource<T> createCustom(ResourceLocation location, FrameworkModelBaker<T> baker) {
        return ClientServices.CLIENT.createModelResource(location, baker);
    }
}

