/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mixin;

import com.mrcrayfish.furniture.refurbished.block.TrampolineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private Level level;
    @Unique
    private float refurbishedFurniture$fallPower;

    @Shadow
    public abstract BlockPos getBlockPosBelowThatAffectsMyMovement();

    @Inject(method={"getBlockJumpFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void refurbishedFurnitureJumpFactor(CallbackInfoReturnable<Float> cir) {
        BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
        BlockState state = this.level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof TrampolineBlock) {
            TrampolineBlock block2 = (TrampolineBlock)block;
            cir.setReturnValue((Object)Float.valueOf(block2.getJumpModifier(this.level, state, pos)));
        }
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getOnPosLegacy()Lnet/minecraft/core/BlockPos;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void refurbishedFurnitureTrampolinePhysics(MoverType type, Vec3 motion, CallbackInfo info, ProfilerFiller profiler, Vec3 moved) {
        Entity entity = (Entity)this;
        if (entity.onGround()) {
            if (this.refurbishedFurniture$fallPower > 0.0f) {
                Block block;
                BlockPos pos = entity.getOnPosLegacy();
                BlockState state = entity.level().getBlockState(pos);
                if (entity.isLocalInstanceAuthoritative() && (block = state.getBlock()) instanceof TrampolineBlock) {
                    TrampolineBlock trampoline = (TrampolineBlock)block;
                    trampoline.applyPhysics(pos, state, entity, this.refurbishedFurniture$fallPower);
                }
                this.refurbishedFurniture$fallPower = 0.0f;
            }
        } else if (moved.y < 0.0) {
            this.refurbishedFurniture$fallPower -= (float)moved.y;
        }
    }
}

