/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.item;

import com.mrcrayfish.furniture.refurbished.block.TelevisionBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.TelevisionBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TelevisionRemoteItem
extends Item {
    public TelevisionRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        Vec3 end;
        Vec3 start = player.getEyePosition();
        BlockHitResult result = level.clip(new ClipContext(start, end = start.add(player.getLookAngle().scale(16.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, (Entity)player));
        if (result.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = result.getBlockPos();
        BlockState state = level.getBlockState(pos);
        if (!state.is((Block)ModBlocks.TELEVISION.get())) {
            return InteractionResult.FAIL;
        }
        Direction direction = (Direction)state.getValue((Property)TelevisionBlock.DIRECTION);
        if (direction.getOpposite() != result.getDirection()) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TelevisionBlockEntity) {
            TelevisionBlockEntity television = (TelevisionBlockEntity)blockEntity;
            television.interact();
        }
        return InteractionResult.CONSUME;
    }
}

