/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessingRecipe
implements Recipe<SingleRecipeInput> {
    protected final RecipeType<? extends Recipe<SingleRecipeInput>> type;
    protected final Category category;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int time;
    @Nullable
    private PlacementInfo placementInfo;

    public ProcessingRecipe(RecipeType<? extends Recipe<SingleRecipeInput>> type, Category category, Ingredient ingredient, ItemStack result, int time) {
        this.type = type;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public RecipeType<? extends Recipe<SingleRecipeInput>> getType() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)this.ingredient);
        }
        return this.placementInfo;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static <T extends ProcessingRecipe> Builder<T> builder(Factory<T> factory, Category category, Ingredient input, ItemStack output, int processTime) {
        return new Builder<T>(factory, category, input, output, processTime);
    }

    public static enum Category implements StringRepresentable
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final StringRepresentable.EnumCodec<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.writeUtf(this.name, 6);
        }

        public static Category fromNetwork(FriendlyByteBuf buf) {
            return Category.byName(buf.readUtf(6));
        }

        public static Category byName(String name) {
            return (Category)CODEC.byName(name, (Enum)MISC);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Category::values);
        }
    }

    public static class Builder<T extends ProcessingRecipe>
    implements RecipeBuilder {
        protected final Category category;
        protected final Factory<T> factory;
        protected final Ingredient input;
        protected final ItemStack output;
        protected final int processTime;
        protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        private Builder(Factory<T> factory, Category category, Ingredient input, ItemStack output, int processTime) {
            this.factory = factory;
            this.category = category;
            this.input = input;
            this.output = output;
            this.processTime = processTime;
        }

        public RecipeBuilder unlockedBy(String s, Criterion<?> instance) {
            this.criteria.put(s, instance);
            return this;
        }

        public RecipeBuilder group(@Nullable String group) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public net.minecraft.world.item.Item getResult() {
            return this.output.getItem();
        }

        public void save(RecipeOutput output, ResourceKey<Recipe<?>> id) {
            Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(id)).rewards(AdvancementRewards.Builder.recipe(id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            output.accept(id, this.factory.create(this.category, this.input, this.output, this.processTime), builder.build(id.location().withPrefix("recipes/" + this.category.getSerializedName() + "/")));
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(Category var1, Ingredient var2, ItemStack var3, int var4);
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        public ItemWithCount(RecipeType<? extends Recipe<SingleRecipeInput>> type, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements RecipeSerializer<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final MapCodec<T> codec;
            private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
                this.streamCodec = StreamCodec.of((buf, recipe) -> {
                    recipe.category.toNetwork((FriendlyByteBuf)buf);
                    Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)recipe.ingredient);
                    ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.result);
                    buf.writeVarInt(recipe.time);
                }, buf -> {
                    Category category = Category.fromNetwork((FriendlyByteBuf)buf);
                    Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
                    ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
                    int processTime = buf.readVarInt();
                    return this.factory.create(category, input, output, processTime);
                });
            }

            public MapCodec<T> codec() {
                return this.codec;
            }

            public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
                return this.streamCodec;
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        public Item(RecipeType<? extends Recipe<SingleRecipeInput>> type, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, category, ingredient, result, time);
        }

        public static Item fromCookingRecipe(final AbstractCookingRecipe recipe, RegistryAccess access) {
            return new Item(recipe.getType(), Category.FOOD, recipe.input(), recipe.assemble(new SingleRecipeInput(ItemStack.EMPTY), (HolderLookup.Provider)access), recipe.cookingTime()){

                public RecipeSerializer<? extends Recipe<SingleRecipeInput>> getSerializer() {
                    return recipe.getSerializer();
                }

                public RecipeBookCategory recipeBookCategory() {
                    return recipe.recipeBookCategory();
                }

                @Override
                public PlacementInfo placementInfo() {
                    return recipe.placementInfo();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        implements RecipeSerializer<T> {
            private final Factory<T> factory;
            private final int defaultTime;
            private final MapCodec<T> codec;
            private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

            public Serializer(Factory<T> factory, int defaultTime) {
                this.factory = factory;
                this.defaultTime = defaultTime;
                this.codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Category.CODEC.fieldOf("category").forGetter(recipe -> recipe.category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("time").orElse((Object)this.defaultTime).forGetter(recipe -> recipe.time)).apply((Applicative)builder, this.factory::create));
                this.streamCodec = StreamCodec.of((buf, recipe) -> {
                    recipe.category.toNetwork((FriendlyByteBuf)buf);
                    Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)recipe.ingredient);
                    ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.result);
                    buf.writeVarInt(recipe.time);
                }, buf -> {
                    Category category = Category.fromNetwork((FriendlyByteBuf)buf);
                    Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
                    ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
                    int processTime = buf.readVarInt();
                    return this.factory.create(category, input, output, processTime);
                });
            }

            public MapCodec<T> codec() {
                return this.codec;
            }

            public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
                return this.streamCodec;
            }
        }
    }
}

