/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.compat.jei.categories;

import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.compat.jei.Plugin;
import com.mrcrayfish.furniture.refurbished.compat.jei.categories.FurnitureRecipeCategory;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class GrillCookingCategory
extends FurnitureRecipeCategory<ProcessingRecipe.Item> {
    public static final Supplier<IRecipeHolderType<ProcessingRecipe.Item>> TYPE = IRecipeHolderType.createDeferred(() -> ModRecipeTypes.GRILL_COOKING.get());
    private final ItemStack campfireStack = new ItemStack((ItemLike)Items.CAMPFIRE);
    private final IGuiHelper helper;
    private IDrawable arrow;

    public GrillCookingCategory(IGuiHelper helper) {
        super(TYPE, (Component)Utils.translation("jei_category", "grill_cooking", new Object[0]), (IDrawable)helper.createDrawable(Plugin.TEXTURES, 135, 57, 121, 79), helper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.GRILL_RED.get())));
        this.helper = helper;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ProcessingRecipe.Item> holder, IFocusGroup focuses) {
        ProcessingRecipe.Item recipe = (ProcessingRecipe.Item)holder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 6).add(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 31).add(recipe.getResult());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 71, 3).add(new ItemStack((ItemLike)ModItems.SPATULA.get()));
        this.arrow = this.helper.createAnimatedDrawable(this.helper.createDrawable(Plugin.TEXTURES, 133, 136, 24, 17), recipe.getTime(), IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Override
    public void draw(RecipeHolder<ProcessingRecipe.Item> holder, IRecipeSlotsView view, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(holder, view, graphics, mouseX, mouseY);
        ProcessingRecipe.Item recipe = (ProcessingRecipe.Item)holder.value();
        this.arrow.draw(graphics, 68, 31);
        this.drawSeconds(graphics, 80, 50, recipe.getTime());
        if (recipe.getType() == RecipeType.CAMPFIRE_COOKING) {
            graphics.fill(99, 5, 115, 21, 0x33000000);
            graphics.renderFakeItem(this.campfireStack, 99, 5);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<ProcessingRecipe.Item> holder, IRecipeSlotsView view, double mouseX, double mouseY) {
        if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 5, 15, 57, 61) && !ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 26, 6, 16, 16)) {
            tooltip.addAll(Plugin.getItemTooltip((ItemLike)ModBlocks.GRILL_RED.get()));
        } else if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, 99, 5, 16, 16)) {
            tooltip.add((FormattedText)Utils.translation("gui", "jei_campfire_info", new Object[0]));
        }
    }
}

