/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class GrillBlockEntityRenderer
implements BlockEntityRenderer<GrillBlockEntity> {
    private final ItemRenderer renderer;

    public GrillBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.getItemRenderer();
    }

    public void render(GrillBlockEntity grill, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay, Vec3 camera) {
        NonNullList<ItemStack> items = grill.getCookingItems();
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            this.drawCookingSpace(grill, stack, poseStack, i, partialTick, source, light, overlay);
        }
        NonNullList<ItemStack> fuel = grill.getFuelItems();
        for (int i = 0; i < fuel.size(); ++i) {
            ItemStack stack = (ItemStack)fuel.get(i);
            if (stack.isEmpty()) continue;
            this.drawFuel(grill, stack, poseStack, i, source, light, overlay);
        }
    }

    private void drawCookingSpace(GrillBlockEntity grill, ItemStack cookingStack, PoseStack poseStack, int quadrant, float partialTick, MultiBufferSource source, int light, int overlay) {
        poseStack.pushPose();
        GrillBlockEntity.CookingSpace space = grill.getCookingSpace(quadrant);
        FlipAnimation animation = space.getAnimation();
        float time = animation.isPlaying() ? animation.getTime(partialTick) : 0.0f;
        float flipProgress = this.calculateFlipProgress(time);
        float flipHeight = 0.75f;
        poseStack.translate(0.0f, flipProgress * flipHeight, 0.0f);
        poseStack.translate(0.3 + 0.4 * (double)(quadrant % 2), 1.0, 0.3 + 0.4 * (double)(quadrant / 2));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(1.5707964f * (float)space.getRotation()));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation((float)Math.PI * -3 * time));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(!animation.isPlaying() && space.isFlipped() ? (float)Math.PI : 0.0f));
        poseStack.scale(0.375f, 0.375f, 0.375f);
        this.renderer.renderStatic(cookingStack, ItemDisplayContext.FIXED, light, overlay, poseStack, source, grill.getLevel(), 0);
        poseStack.popPose();
    }

    private void drawFuel(GrillBlockEntity grill, ItemStack fuelStack, PoseStack poseStack, int index, MultiBufferSource source, int light, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.3 + 0.2 * (double)(index % 3), 0.85, 0.3 + 0.2 * (double)(index / 3));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(10.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(10.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(5.0f));
        poseStack.scale(0.375f, 0.375f, 0.375f);
        this.renderer.renderStatic(fuelStack, ItemDisplayContext.FIXED, light, overlay, poseStack, source, grill.getLevel(), 0);
        poseStack.popPose();
    }

    private float calculateFlipProgress(float time) {
        if ((double)time <= 0.5) {
            return 1.0f - (float)Math.pow(1.0f - (time /= 0.5f), 4.0);
        }
        time -= 0.5f;
        return 1.0f - (time /= 0.5f) * time * time * time;
    }
}

