/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.widget;

import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class IconButton
extends Button {
    public static final ResourceLocation ICON_TEXTURES = Utils.resource("textures/gui/icons.png");
    private final Component label;
    private final int u;
    private final int v;

    public IconButton(int x, int y, int u, int v, Button.OnPress onPress) {
        this(x, y, u, v, 20, CommonComponents.EMPTY, onPress);
    }

    public IconButton(int x, int y, int u, int v, int width, Component label, Button.OnPress onPress) {
        this(x, y, u, v, width, 20, label, onPress);
    }

    public IconButton(int x, int y, int u, int v, int width, int height, Component label, Button.OnPress onPress) {
        super(x, y, width, height, CommonComponents.EMPTY, onPress, Button.DEFAULT_NARRATION);
        this.label = label;
        this.u = u;
        this.v = v;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        Minecraft minecraft = Minecraft.getInstance();
        int contentWidth = 10 + minecraft.font.width((FormattedText)this.label) + (!this.label.getString().isEmpty() ? 4 : 0);
        int iconX = this.getX() + (this.width - contentWidth) / 2;
        int iconY = this.getY() + (this.height - 10) / 2;
        int brightness = ARGB.scaleRGB((int)-1, (float)(this.active ? 1.0f : 0.5f));
        graphics.blit(RenderPipelines.GUI_TEXTURED, ICON_TEXTURES, iconX, iconY, (float)this.u, (float)this.v, 10, 10, 64, 64, brightness);
        int textColor = (this.active ? 0xFFFFFF : 0xA0A0A0) | 0xFF000000;
        IconButton.renderScrollingString((GuiGraphics)graphics, (Font)minecraft.font, (Component)this.label, (int)(iconX + 14), (int)this.getY(), (int)(iconX + contentWidth), (int)(this.getY() + this.getHeight()), (int)textColor);
    }
}

