/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity.fluid;

import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWaterTapAnimation;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IFluidContainerBlock {
    @Nullable
    public FluidContainer getFluidContainer();

    default public InteractionResult tryAndFillWithFluid(Level level, BlockPos pos, Fluid fluid, @Nullable Vec3 splashPos) {
        FluidContainer container = this.getFluidContainer();
        if (container == null) {
            return InteractionResult.PASS;
        }
        if (!container.isEmpty() && !container.getStoredFluid().isSame(fluid)) {
            return InteractionResult.PASS;
        }
        if (container.getStoredAmount() >= container.getCapacity()) {
            return InteractionResult.PASS;
        }
        long filled = container.push(fluid, FluidContainer.BUCKET_CAPACITY, false);
        if (filled > 0L) {
            SoundEvent event;
            if (fluid.isSame((Fluid)Fluids.WATER)) {
                BlockEntity entity;
                IFluidContainerBlock iFluidContainerBlock;
                if (splashPos != null && !level.isClientSide()) {
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SPLASH, splashPos.x, splashPos.y, splashPos.z, 10, 0.0, 0.0, 0.0, 0.0);
                }
                if ((iFluidContainerBlock = this) instanceof BlockEntity && (entity = (BlockEntity)iFluidContainerBlock) instanceof IWaterTap && !level.isClientSide()) {
                    Network.getPlay().sendToTrackingBlockEntity(() -> entity, (Object)new MessageWaterTapAnimation(pos));
                    level.playSound(null, pos, (SoundEvent)ModSounds.BLOCK_KITCHEN_SINK_FILL.get(), SoundSource.BLOCKS);
                }
            }
            if ((event = Services.FLUID.getBucketEmptySound(fluid)) != null && !level.isClientSide()) {
                Vec3 soundPos = splashPos != null ? splashPos : new Vec3((Vec3i)pos);
                level.playSound(null, soundPos.x, soundPos.y, soundPos.z, event, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult tryAndCreateObsidian(Level level, BlockPos pos, Fluid dispensingFluid, Vec3 spawnPos) {
        FluidContainer container = this.getFluidContainer();
        if (container == null) {
            return InteractionResult.PASS;
        }
        if (!dispensingFluid.isSame((Fluid)Fluids.WATER)) {
            return InteractionResult.PASS;
        }
        if (container.getStoredAmount() < FluidContainer.BUCKET_CAPACITY || !container.getStoredFluid().isSame((Fluid)Fluids.LAVA)) {
            return InteractionResult.PASS;
        }
        Pair<Fluid, Long> drained = container.pull(FluidContainer.BUCKET_CAPACITY, true);
        if ((Long)drained.right() != FluidContainer.BUCKET_CAPACITY) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            container.pull(FluidContainer.BUCKET_CAPACITY, false);
            ItemEntity entity = new ItemEntity(level, spawnPos.x, spawnPos.y, spawnPos.z, new ItemStack((ItemLike)Blocks.OBSIDIAN));
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
            level.playSound(null, spawnPos.x, spawnPos.y, spawnPos.z, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS);
            level.levelEvent(1501, pos, 0);
            IFluidContainerBlock iFluidContainerBlock = this;
            if (iFluidContainerBlock instanceof BlockEntity) {
                BlockEntity blockEntity = (BlockEntity)iFluidContainerBlock;
                Network.getPlay().sendToTrackingBlockEntity(() -> blockEntity, (Object)new MessageWaterTapAnimation(pos));
            }
        }
        return InteractionResult.SUCCESS;
    }

    default public InteractionResult interactWithBottle(Player player, InteractionHand hand, BlockPos pos) {
        PotionContents contents;
        FluidContainer container = this.getFluidContainer();
        if (container == null) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.is(Items.GLASS_BOTTLE)) {
            if (container.getStoredAmount() >= FluidContainer.BOTTLE_CAPACITY && container.getStoredFluid().isSame((Fluid)Fluids.WATER)) {
                Level level = player.level();
                if (!level.isClientSide()) {
                    container.pull(FluidContainer.BOTTLE_CAPACITY, false);
                    Item bottle = heldItem.getItem();
                    player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)heldItem, (Player)player, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)));
                    player.awardStat(Stats.ITEM_USED.get((Object)bottle));
                    player.level().playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.level().gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (heldItem.is(Items.POTION) && (contents = (PotionContents)heldItem.get(DataComponents.POTION_CONTENTS)) != null && contents.is(Potions.WATER) && (container.isEmpty() || container.getStoredAmount() < container.getCapacity() && container.getStoredFluid().isSame((Fluid)Fluids.WATER))) {
            Level level = player.level();
            if (!level.isClientSide()) {
                container.push((Fluid)Fluids.WATER, FluidContainer.BOTTLE_CAPACITY, false);
                Item potion = heldItem.getItem();
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)heldItem, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Stats.ITEM_USED.get((Object)potion));
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public InteractionResult performPlatformInteraction(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        return Services.FLUID.performInteractionWithBlock(player, hand, player.level(), pos, face);
    }
}

