/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IModuleNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class ElectricityModuleLootBlockEntity
extends BasicLootBlockEntity
implements IModuleNode {
    protected final Set<Connection> connections = new HashSet<Connection>();
    protected final Set<BlockPos> powerSources = new HashSet<BlockPos>();
    protected boolean receivingPower;

    public ElectricityModuleLootBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int containerSize) {
        super(type, pos, state, containerSize);
    }

    @Override
    public Level getNodeLevel() {
        return this.level;
    }

    @Override
    public BlockPos getNodePosition() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getNodeOwner() {
        return this;
    }

    @Override
    public Set<Connection> getNodeConnections() {
        return this.connections;
    }

    @Override
    public void setNodeReceivingPower(boolean state) {
        this.receivingPower = state;
    }

    @Override
    public boolean isNodeReceivingPower() {
        return this.receivingPower;
    }

    @Override
    public Set<BlockPos> getPowerSources() {
        return this.powerSources;
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.readNodeNbt(input);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeNodeNbt(output);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate((double)((Integer)Config.CLIENT.electricityViewDistance.get()).intValue());
    }

    public int hashCode() {
        return this.worldPosition.hashCode();
    }

    public void removeComponentsFromTag(ValueOutput output) {
        output.discard("Connections");
        output.discard("NodePos");
        output.discard("Powered");
        output.discard("Overloaded");
    }
}

