/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.world.level.block.behavior.GrowingPlantBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;

public class SimpleGrowingPlantBehavior
extends GrowingPlantBehavior {
    @Override
    public boolean isValidBonemealTarget(LevelReader level, BlockPos blockPos, BlockState blockState) {
        if (this.getConnectedPlantHeight((BlockGetter)level, blockPos, blockState.getBlock()) < this.getMaxHeightAtPosition(blockPos.getX(), blockPos.getZ())) {
            return super.isValidBonemealTarget(level, blockPos, blockState);
        }
        return false;
    }

    private int getConnectedPlantHeight(BlockGetter blockGetter, BlockPos pos, Block block) {
        BlockPos pos1 = SimpleGrowingPlantBehavior.getTopConnectedBlock(blockGetter, pos, block, this.getGrowthDirection());
        BlockPos pos2 = SimpleGrowingPlantBehavior.getTopConnectedBlock(blockGetter, pos, block, this.getGrowthDirection().getOpposite());
        return Math.abs(pos1.getY() - pos2.getY());
    }

    private int getMaxHeightAtPosition(int posX, int posZ) {
        return 12 + WorldgenRandom.seedSlimeChunk((int)posX, (int)posZ, (long)0L, (long)987234911L).nextInt(5);
    }

    @Override
    protected void performBonemealTop(ServerLevel serverLevel, RandomSource randomSource, BlockPos topPos, BlockState sourceState) {
        super.performBonemealTop(serverLevel, randomSource, topPos, sourceState);
        BlockState blockState = (BlockState)serverLevel.getBlockState(topPos).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0));
        serverLevel.setBlockAndUpdate(topPos, blockState);
        blockState.updateNeighbourShapes((LevelAccessor)serverLevel, topPos, 3);
    }

    @Override
    protected Direction getGrowthDirection() {
        return Direction.UP;
    }

    protected IntegerProperty getAgeProperty() {
        return BlockStateProperties.AGE_15;
    }

    @Override
    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1 + random.nextInt(2);
    }

    @Override
    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    @Override
    protected BlockState getGrownBlockState(BlockState sourceState, RandomSource randomSource) {
        return sourceState.getBlock().defaultBlockState();
    }
}

