/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.network;

import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ClientboundPlayMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ParticleUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public record ClientboundGrowthParticlesMessage(BlockPos blockPos) implements ClientboundPlayMessage
{
    public static final StreamCodec<ByteBuf, ClientboundGrowthParticlesMessage> STREAM_CODEC = BlockPos.STREAM_CODEC.map(ClientboundGrowthParticlesMessage::new, ClientboundGrowthParticlesMessage::blockPos);

    public MessageListener<ClientboundPlayMessage.Context> getListener() {
        return new MessageListener<ClientboundPlayMessage.Context>(){

            public void accept(ClientboundPlayMessage.Context context) {
                this.addGrowthParticles((Level)context.level(), ClientboundGrowthParticlesMessage.this.blockPos, 15);
            }

            private void addGrowthParticles(Level level, BlockPos blockPos, int data) {
                if (level.getBlockState(blockPos).isSolidRender()) {
                    ParticleUtils.spawnParticles((LevelAccessor)level, (BlockPos)blockPos.above(), (int)(data * 3), (double)3.0, (double)1.0, (boolean)false, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                } else {
                    ParticleUtils.spawnParticleInBlock((LevelAccessor)level, (BlockPos)blockPos, (int)data, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                }
            }
        };
    }
}

