/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.world.level.block.entity;

import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.util.v1.ValueSerializationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class ItemFrameBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    static final String TAG_COLOR = FastItemFrames.id("color").toString();
    static final String TAG_ITEM_FRAME = FastItemFrames.id("item_frame").toString();
    @Nullable
    private ItemFrame itemFrame;
    @Nullable
    private CompoundTag storedTag;
    @Nullable
    private DyedItemColor color;

    public ItemFrameBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.value(), pos, blockState);
    }

    public void serverTick() {
        MapId mapId;
        MapItemSavedData mapItemSavedData;
        ItemStack itemStack;
        if (this.hasLevel() && ((ServerLevel)this.getLevel()).getServer().getTickCount() % 10 == 0 && (itemStack = this.getItem()).getItem() instanceof MapItem && (mapItemSavedData = MapItem.getSavedData((MapId)(mapId = (MapId)itemStack.get(DataComponents.MAP_ID)), (Level)this.getLevel())) != null) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.getLevel()).players()) {
                mapItemSavedData.tickCarriedBy((Player)serverPlayer, itemStack);
                Packet packet = mapItemSavedData.getUpdatePacket(mapId, (Player)serverPlayer);
                if (packet == null) continue;
                serverPlayer.connection.send(packet);
            }
        }
    }

    public void load(ItemFrame itemFrame) {
        CompoundTag compoundTag = ValueSerializationHelper.save((ProblemReporter.PathElement)this.problemPath(), (HolderLookup.Provider)itemFrame.registryAccess(), arg_0 -> ((ItemFrame)itemFrame).saveWithoutId(arg_0));
        this.loadItemFrame(compoundTag);
        this.color = (DyedItemColor)ModRegistry.ITEM_FRAME_COLOR_ATTACHMENT_TYPE.get((Object)itemFrame);
    }

    public void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        valueInput.read(TAG_ITEM_FRAME, CompoundTag.CODEC).ifPresent(this::loadItemFrame);
        this.color = valueInput.read(TAG_COLOR, DyedItemColor.CODEC).orElse(null);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.storeNullable(TAG_ITEM_FRAME, CompoundTag.CODEC, (Object)this.getItemFrameTag());
        valueOutput.storeNullable(TAG_COLOR, DyedItemColor.CODEC, (Object)this.color);
    }

    @Nullable
    private CompoundTag getItemFrameTag() {
        ItemFrame itemFrame = this.getEntityRepresentation();
        if (itemFrame != null) {
            return ValueSerializationHelper.save((ProblemReporter.PathElement)this.problemPath(), (HolderLookup.Provider)itemFrame.registryAccess(), arg_0 -> ((ItemFrame)itemFrame).saveWithoutId(arg_0));
        }
        if (this.storedTag != null) {
            return this.storedTag;
        }
        return null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        super.preRemoveSideEffects(blockPos, blockState);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemFrame itemFrame = this.getEntityRepresentation();
            if (itemFrame != null) {
                itemFrame.dropItem(serverLevel, null, false);
                this.setChanged();
            }
        }
    }

    protected void applyImplicitComponents(DataComponentGetter dataComponentGetter) {
        super.applyImplicitComponents(dataComponentGetter);
        this.color = (DyedItemColor)dataComponentGetter.get(DataComponents.DYED_COLOR);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.color != null) {
            components.set(DataComponents.DYED_COLOR, (Object)this.color);
        }
    }

    public void removeComponentsFromTag(ValueOutput valueOutput) {
        valueOutput.discard(TAG_COLOR);
    }

    @Nullable
    public DyedItemColor getColor() {
        return this.color;
    }

    public ItemStack getItem() {
        ItemFrame itemFrame = this.getEntityRepresentation();
        return itemFrame != null ? itemFrame.getItem() : ItemStack.EMPTY;
    }

    public boolean isInvisible() {
        return (Boolean)this.getBlockState().getValue((Property)ItemFrameBlock.INVISIBLE);
    }

    public void markUpdated() {
        if (this.hasLevel()) {
            this.getLevel().setBlock(this.getBlockPos(), this.getUpdatedBlockState(), 2);
            this.setChanged();
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private BlockState getUpdatedBlockState() {
        BlockState blockState = this.getBlockState();
        ItemFrame itemFrame = this.getEntityRepresentation();
        if (itemFrame != null) {
            return (BlockState)((BlockState)((BlockState)blockState.setValue((Property)ItemFrameBlock.MAP, (Comparable)Boolean.valueOf(itemFrame.hasFramedMap()))).setValue((Property)ItemFrameBlock.DYED, (Comparable)Boolean.valueOf(this.color != null))).setValue((Property)ItemFrameBlock.INVISIBLE, (Comparable)Boolean.valueOf(itemFrame.isInvisible() && !itemFrame.getItem().isEmpty()));
        }
        return blockState;
    }

    @Nullable
    public ItemFrame getEntityRepresentation() {
        return this.getEntityRepresentation(false);
    }

    @Nullable
    public ItemFrame getEntityRepresentation(boolean skipInit) {
        if (this.itemFrame == null && this.hasLevel()) {
            EntityType type = ((HangingEntityItem)this.getBlockState().getBlock().asItem()).type;
            ItemFrame itemFrame = (ItemFrame)type.create(this.getLevel(), EntitySpawnReason.LOAD);
            if (!skipInit) {
                this.initItemFrame(itemFrame, this.storedTag);
            }
            this.storedTag = null;
            this.itemFrame = itemFrame;
            return this.itemFrame;
        }
        return this.itemFrame;
    }

    private void loadItemFrame(CompoundTag compoundTag) {
        ItemFrame itemFrame = this.getEntityRepresentation(true);
        if (itemFrame != null) {
            this.initItemFrame(itemFrame, compoundTag);
        } else {
            this.storedTag = compoundTag;
        }
    }

    private void initItemFrame(ItemFrame itemFrame, @Nullable CompoundTag compoundTag) {
        itemFrame.setItem(ItemStack.EMPTY, false);
        BlockPos pos = this.getBlockPos();
        itemFrame.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (compoundTag != null) {
            ValueSerializationHelper.load((ProblemReporter.PathElement)this.problemPath(), (HolderLookup.Provider)itemFrame.registryAccess(), (CompoundTag)compoundTag, arg_0 -> ((ItemFrame)itemFrame).load(arg_0));
        }
        itemFrame.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        itemFrame.setDirection((Direction)this.getBlockState().getValue(ItemFrameBlock.FACING));
    }
}

