/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import fuzs.puzzleslib.api.util.v1.ShapesHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemFrameItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ItemFrameBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
TickingEntityBlock<ItemFrameBlockEntity> {
    public static final MapCodec<ItemFrameBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(itemFrame -> itemFrame.item), (App)ItemFrameBlock.propertiesCodec()).apply((Applicative)instance, ItemFrameBlock::new));
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty MAP = BlockStateProperties.MAP;
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    public static final BooleanProperty DYED = BooleanProperty.create((String)"dyed");
    static final VoxelShape SHAPE = ItemFrameBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    static final VoxelShape MAP_SHAPE = ItemFrameBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    static final Map<Direction, VoxelShape> SHAPES = ShapesHelper.rotate((VoxelShape)SHAPE);
    static final Map<Direction, VoxelShape> MAP_SHAPES = ShapesHelper.rotate((VoxelShape)MAP_SHAPE);
    public static final Map<Item, Block> BY_ITEM = new HashMap<Item, Block>();
    private final Item item;

    public ItemFrameBlock(Item item, BlockBehaviour.Properties properties) {
        super(properties);
        this.item = item;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)MAP, (Comparable)Boolean.FALSE)).setValue((Property)INVISIBLE, (Comparable)Boolean.FALSE)).setValue((Property)DYED, (Comparable)Boolean.FALSE));
        Item.BY_BLOCK.put(this, item);
        BY_ITEM.put(item, (Block)this);
    }

    protected MapCodec<? extends ItemFrameBlock> codec() {
        return CODEC;
    }

    public Item asItem() {
        return this.item;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useItemOn(ItemStack itemInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemFrameBlockEntity blockEntity;
        ItemFrame itemFrame;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
            InteractionResult interactionResult;
            if (player.isSecondaryUseActive() && !this.isFixed((LevelReader)level, pos) && !itemFrame.getItem().isEmpty()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)INVISIBLE) == false)), 2);
                itemFrame.playSound(itemFrame.getRotateItemSound(), 1.0f, 1.0f);
                return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide);
            }
            if (itemFrame.getItem().isEmpty()) {
                itemFrame.setRotation(0);
            }
            if ((interactionResult = itemFrame.interact(player, hand)).consumesAction()) {
                blockEntity.markUpdated();
            }
            return interactionResult;
        }
        return super.useItemOn(itemInHand, state, level, pos, player, hand, hitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)MAP) != false ? MAP_SHAPES.get(state.getValue(FACING)) : SHAPES.get(state.getValue(FACING));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollisionContext = (EntityCollisionContext)context).getEntity()) instanceof Projectile) {
            ServerLevel serverLevel;
            Projectile projectile = (Projectile)entity;
            if (blockGetter instanceof ServerLevel && projectile.mayInteract(serverLevel = (ServerLevel)blockGetter, pos) && projectile.mayBreak(serverLevel)) {
                return this.getShape(state, blockGetter, pos, context);
            }
        }
        return super.getCollisionShape(state, blockGetter, pos, context);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isFixed(level, pos)) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos.relative(((Direction)state.getValue(FACING)).getOpposite()));
        return blockState.isSolid() || DiodeBlock.isDiode((BlockState)blockState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction.getOpposite() == state.getValue(FACING) && !state.canSurvive(level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntityType<? extends ItemFrameBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.ITEM_FRAME_BLOCK_ENTITY.value();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, INVISIBLE, MAP, WATERLOGGED, DYED});
    }

    public boolean isFixed(LevelReader level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ItemFrameBlockEntity) {
            ItemFrameBlockEntity blockEntity2 = (ItemFrameBlockEntity)blockEntity;
            ItemFrame itemFrame = blockEntity2.getEntityRepresentation();
            return itemFrame != null && itemFrame.fixed;
        }
        return false;
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.getBlockPos();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isFixed((LevelReader)level, blockPos) && projectile.mayInteract(serverLevel, blockPos) && projectile.mayBreak(serverLevel)) {
                level.destroyBlock(blockPos, true, (Entity)projectile);
                level.updateNeighborsAt(blockPos, (Block)this);
                level.updateNeighborsAt(blockPos.relative(((Direction)state.getValue(FACING)).getOpposite()), (Block)this);
            }
        }
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean movedByPiston) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        ItemFrameBlockEntity blockEntity;
        ItemFrame itemFrame;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof ItemFrameBlockEntity && (itemFrame = (blockEntity = (ItemFrameBlockEntity)blockEntity2).getEntityRepresentation()) != null) {
            return itemFrame.getAnalogOutput();
        }
        return 0;
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos blockPos, BlockState blockState, boolean includeData) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ItemFrameBlockEntity) {
            ItemFrame itemFrame;
            ItemFrameBlockEntity blockEntity2 = (ItemFrameBlockEntity)blockEntity;
            ItemStack itemStack = null;
            if ((!CommonHelper.hasControlDown() || ModLoaderEnvironment.INSTANCE.isClient() && !CommonHelper.getClientPlayer().isCreative()) && (itemFrame = blockEntity2.getEntityRepresentation()) != null) {
                itemStack = itemFrame.getPickResult();
            }
            if (itemStack == null) {
                itemStack = super.getCloneItemStack(level, blockPos, blockState, includeData);
            }
            if (itemStack.getItem() instanceof ItemFrameItem) {
                ItemFrameBlock.setItemFrameColor(itemStack, blockEntity2.getColor());
            }
            return itemStack;
        }
        return super.getCloneItemStack(level, blockPos, blockState, includeData);
    }

    public static ItemStack setItemFrameColor(ItemStack itemStack, @Nullable DyedItemColor color) {
        if (color != null) {
            itemStack.set(DataComponents.DYED_COLOR, (Object)color);
        }
        return itemStack;
    }
}

