/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fastitemframes.client.handler.ClientEventHandler;
import fuzs.fastitemframes.client.renderer.blockentity.ItemFrameBlockRenderer;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFrameRenderer.class})
abstract class ItemFrameRendererMixin<T extends ItemFrame>
extends EntityRenderer<T, ItemFrameRenderState> {
    @Shadow
    @Final
    private BlockRenderDispatcher blockRenderer;

    protected ItemFrameRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/entity/state/ItemFrameRenderState;isInvisible:Z", shift=At.Shift.BEFORE, ordinal=0)})
    public void render(ItemFrameRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo callback) {
        if (RenderPropertyKey.has((EntityRenderState)renderState, ClientEventHandler.COLOR_RENDER_PROPERTY_KEY)) {
            int color = (Integer)RenderPropertyKey.get((EntityRenderState)renderState, ClientEventHandler.COLOR_RENDER_PROPERTY_KEY);
            BlockState blockState = ItemFrameBlockRenderer.getItemFrameBlockState(renderState.isGlowFrame, renderState.mapId != null, true);
            BlockStateModel blockStateModel = this.blockRenderer.getBlockModel(blockState);
            poseStack.pushPose();
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            float red = ARGB.redFloat((int)color);
            float green = ARGB.greenFloat((int)color);
            float blue = ARGB.blueFloat((int)color);
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderType.entitySolidZOffsetForward((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), (BlockStateModel)blockStateModel, (float)red, (float)green, (float)blue, (int)packedLight, (int)OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            if (!renderState.item.isEmpty()) {
                poseStack.translate(0.0f, 0.0f, -0.0625f);
            }
        }
    }
}

