/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.data.client;

import com.mojang.math.Quadrant;
import fuzs.fastitemframes.FastItemFrames;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.client.data.v2.models.ModelLocationHelper;
import fuzs.puzzleslib.api.client.data.v2.models.ModelTemplateHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.conditional.HasComponent;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ModModelProvider
extends AbstractModelProvider {
    public static final TextureSlot WOOD = TextureSlot.create((String)"wood");
    public static final ModelTemplate TEMPLATE_ITEM_FRAME_DYED = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)FastItemFrames.id("template_item_frame_dyed"), (TextureSlot[])new TextureSlot[]{WOOD, TextureSlot.BACK, TextureSlot.PARTICLE});
    public static final ModelTemplate TEMPLATE_ITEM_FRAME_MAP_DYED = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)FastItemFrames.id("template_item_frame_map_dyed"), (TextureSlot[])new TextureSlot[]{WOOD, TextureSlot.BACK, TextureSlot.PARTICLE});
    public static final ModelTemplate TEMPLATE_GLOW_ITEM_FRAME = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)FastItemFrames.id("template_glow_item_frame"), (TextureSlot[])new TextureSlot[]{WOOD, TextureSlot.BACK, TextureSlot.PARTICLE});
    public static final ModelTemplate TEMPLATE_GLOW_ITEM_FRAME_MAP = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)FastItemFrames.id("template_glow_item_frame_map"), (TextureSlot[])new TextureSlot[]{WOOD, TextureSlot.BACK, TextureSlot.PARTICLE});
    public static final ModelTemplate TEMPLATE_GLOW_ITEM_FRAME_DYED = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)FastItemFrames.id("template_glow_item_frame_dyed"), (TextureSlot[])new TextureSlot[]{WOOD, TextureSlot.BACK, TextureSlot.PARTICLE});
    public static final ModelTemplate TEMPLATE_GLOW_ITEM_FRAME_MAP_DYED = ModelTemplateHelper.createBlockModelTemplate((ResourceLocation)FastItemFrames.id("template_glow_item_frame_map_dyed"), (TextureSlot[])new TextureSlot[]{WOOD, TextureSlot.BACK, TextureSlot.PARTICLE});
    public static final PropertyDispatch<VariantMutator> ROTATIONS_ITEM_FRAME_FACING = PropertyDispatch.modify((Property)BlockStateProperties.FACING).select((Comparable)Direction.DOWN, (Object)VariantMutator.X_ROT.withValue((Object)Quadrant.R90).then(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180))).select((Comparable)Direction.UP, (Object)VariantMutator.X_ROT.withValue((Object)Quadrant.R270).then(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180))).select((Comparable)Direction.NORTH, (Object)BlockModelGenerators.NOP).select((Comparable)Direction.SOUTH, (Object)VariantMutator.Y_ROT.withValue((Object)Quadrant.R180)).select((Comparable)Direction.WEST, (Object)VariantMutator.Y_ROT.withValue((Object)Quadrant.R270)).select((Comparable)Direction.EAST, (Object)VariantMutator.Y_ROT.withValue((Object)Quadrant.R90));

    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public static TextureMapping createItemFrameMapping(Block block) {
        return ModModelProvider.createItemFrameMapping(ModelLocationHelper.getBlockTexture((Block)block));
    }

    public static TextureMapping createItemFrameMapping(ResourceLocation resourceLocation) {
        return new TextureMapping().put(WOOD, ModelLocationHelper.getBlockTexture((Block)Blocks.BIRCH_PLANKS)).put(TextureSlot.BACK, resourceLocation).put(TextureSlot.PARTICLE, ModelLocationHelper.getBlockTexture((Block)Blocks.BIRCH_PLANKS));
    }

    public void addBlockModels(BlockModelGenerators blockModelGenerators) {
        this.createItemFrame((Block)ModRegistry.ITEM_FRAME_BLOCK.value(), blockModelGenerators);
        this.createGlowItemFrame((Block)ModRegistry.GLOW_ITEM_FRAME_BLOCK.value(), blockModelGenerators);
    }

    public final void createItemFrame(Block block, BlockModelGenerators blockModelGenerators) {
        ResourceLocation blockModel = ModelLocationHelper.getBlockModel((ResourceLocation)ResourceLocationHelper.withDefaultNamespace((String)ModelLocationHelper.getBlockName((Block)block)));
        ResourceLocation mapModel = ModelLocationHelper.getBlockModel((ResourceLocation)ResourceLocationHelper.withDefaultNamespace((String)ModelLocationHelper.getBlockName((Block)block)), (String)"_map");
        ResourceLocation dyedBlockModel = TEMPLATE_ITEM_FRAME_DYED.createWithSuffix(block, "_dyed", ModModelProvider.createItemFrameMapping(block), blockModelGenerators.modelOutput);
        ResourceLocation dyedMapModel = TEMPLATE_ITEM_FRAME_MAP_DYED.createWithSuffix(block, "_map_dyed", ModModelProvider.createItemFrameMapping(block), blockModelGenerators.modelOutput);
        this.createItemFrame(block, blockModel, mapModel, dyedBlockModel, dyedMapModel, blockModelGenerators);
    }

    public final void createGlowItemFrame(Block block, BlockModelGenerators blockModelGenerators) {
        ResourceLocation blockModel = TEMPLATE_GLOW_ITEM_FRAME.create(block, ModModelProvider.createItemFrameMapping(ModelLocationHelper.getBlockTexture((ResourceLocation)ResourceLocationHelper.withDefaultNamespace((String)ModelLocationHelper.getBlockName((Block)block)))), blockModelGenerators.modelOutput);
        ResourceLocation mapModel = TEMPLATE_GLOW_ITEM_FRAME_MAP.createWithSuffix(block, "_map", ModModelProvider.createItemFrameMapping(ModelLocationHelper.getBlockModel((ResourceLocation)ResourceLocationHelper.withDefaultNamespace((String)ModelLocationHelper.getBlockName((Block)block)))), blockModelGenerators.modelOutput);
        ResourceLocation dyedBlockModel = TEMPLATE_GLOW_ITEM_FRAME_DYED.createWithSuffix(block, "_dyed", ModModelProvider.createItemFrameMapping(block), blockModelGenerators.modelOutput);
        ResourceLocation dyedMapModel = TEMPLATE_GLOW_ITEM_FRAME_MAP_DYED.createWithSuffix(block, "_map_dyed", ModModelProvider.createItemFrameMapping(block), blockModelGenerators.modelOutput);
        this.createItemFrame(block, blockModel, mapModel, dyedBlockModel, dyedMapModel, blockModelGenerators);
    }

    public final void createItemFrame(Block block, ResourceLocation blockModel, ResourceLocation mapModel, ResourceLocation dyedBlockModel, ResourceLocation dyedMapModel, BlockModelGenerators blockModelGenerators) {
        ResourceLocation invisibleModel = ModelTemplates.PARTICLE_ONLY.create(ModelLocationHelper.getBlockModel((Block)block, (String)"_invisible"), TextureMapping.particle((Block)Blocks.BIRCH_PLANKS), blockModelGenerators.modelOutput);
        blockModelGenerators.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)ItemFrameBlock.MAP, (Property)ItemFrameBlock.DYED).select((Comparable)Boolean.FALSE, (Comparable)Boolean.FALSE, (Object)BlockModelGenerators.plainVariant((ResourceLocation)blockModel)).select((Comparable)Boolean.TRUE, (Comparable)Boolean.FALSE, (Object)BlockModelGenerators.plainVariant((ResourceLocation)mapModel)).select((Comparable)Boolean.FALSE, (Comparable)Boolean.TRUE, (Object)BlockModelGenerators.plainVariant((ResourceLocation)dyedBlockModel)).select((Comparable)Boolean.TRUE, (Comparable)Boolean.TRUE, (Object)BlockModelGenerators.plainVariant((ResourceLocation)dyedMapModel))).with((PropertyDispatch)PropertyDispatch.modify((Property)ItemFrameBlock.INVISIBLE).select((Comparable)Boolean.TRUE, (Object)VariantMutator.MODEL.withValue((Object)invisibleModel)).select((Comparable)Boolean.FALSE, (Object)BlockModelGenerators.NOP)).with(ROTATIONS_ITEM_FRAME_FACING));
    }

    public void addItemModels(ItemModelGenerators itemModelGenerators) {
        this.generateItemFrame(Items.ITEM_FRAME, itemModelGenerators);
        this.generateItemFrame(Items.GLOW_ITEM_FRAME, itemModelGenerators);
    }

    public final void generateItemFrame(Item item, ItemModelGenerators itemModelGenerators) {
        ItemModel.Unbaked itemModel = ItemModelUtils.plainModel((ResourceLocation)ModelLocationHelper.getItemModel((Item)item));
        ResourceLocation resourceLocation = FastItemFrames.id(ModelLocationHelper.getItemName((Item)item));
        ItemModel.Unbaked dyedModel = ItemModelUtils.tintedModel((ResourceLocation)itemModelGenerators.generateLayeredItem(ModelLocationHelper.getItemModel((ResourceLocation)resourceLocation), ModelLocationHelper.getItemTexture((ResourceLocation)resourceLocation), ModelLocationHelper.getItemTexture((ResourceLocation)resourceLocation, (String)"_overlay")), (ItemTintSource[])new ItemTintSource[]{new Dye(-1)});
        itemModelGenerators.generateBooleanDispatch(item, (ConditionalItemModelProperty)new HasComponent(DataComponents.DYED_COLOR, false), dyedModel, itemModel);
    }
}

