/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fastitemframes.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.fastitemframes.init.ModRegistry;
import fuzs.fastitemframes.world.level.block.ItemFrameBlock;
import fuzs.fastitemframes.world.level.block.entity.ItemFrameBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemFrameBlockRenderer
implements BlockEntityRenderer<ItemFrameBlockEntity> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final EntityRenderDispatcher entityRenderDispatcher;

    public ItemFrameBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderDispatcher = context.getEntityRenderer();
    }

    public static BlockState getItemFrameBlockState(boolean isGlowFrame, boolean isMapFrame, boolean isDyed) {
        Block block = ItemFrameBlockRenderer.getItemFrameBlock(isGlowFrame);
        return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)ItemFrameBlock.MAP, (Comparable)Boolean.valueOf(isMapFrame))).setValue((Property)ItemFrameBlock.DYED, (Comparable)Boolean.valueOf(isDyed));
    }

    private static Block getItemFrameBlock(boolean isGlowFrame) {
        return isGlowFrame ? (Block)ModRegistry.GLOW_ITEM_FRAME_BLOCK.value() : (Block)ModRegistry.ITEM_FRAME_BLOCK.value();
    }

    public void render(ItemFrameBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPosition) {
        ItemFrame itemFrame;
        if (!blockEntity.getItem().isEmpty() && (itemFrame = blockEntity.getEntityRepresentation()) != null) {
            EntityRenderer entityRenderer = this.entityRenderDispatcher.getRenderer((Entity)itemFrame);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.25f, 0.5f);
            Direction direction = itemFrame.getDirection();
            poseStack.translate((float)direction.getStepX() * -0.1675f, (float)direction.getStepY() * -0.46875f, (float)direction.getStepZ() * -0.1675f);
            if (!blockEntity.isInvisible()) {
                poseStack.translate((float)direction.getStepX() * 0.0625f, (float)direction.getStepY() * 0.0625f, (float)direction.getStepZ() * 0.0625f);
            }
            ItemFrameRenderState renderState = (ItemFrameRenderState)entityRenderer.createRenderState((Entity)itemFrame, partialTick);
            renderState.isInvisible = true;
            if (this.shouldShowName(blockEntity, itemFrame)) {
                renderState.nameTag = entityRenderer.getNameTag((Entity)itemFrame);
            }
            if (renderState.nameTag != null) {
                entityRenderer.renderNameTag((EntityRenderState)renderState, renderState.nameTag, poseStack, bufferSource, packedLight);
            }
            entityRenderer.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
            poseStack.popPose();
        }
    }

    public boolean shouldRender(ItemFrameBlockEntity blockEntity, Vec3 cameraPos) {
        ItemFrame itemFrame = blockEntity.getEntityRepresentation();
        if (itemFrame != null) {
            return itemFrame.shouldRender(cameraPos.x(), cameraPos.y(), cameraPos.z());
        }
        return super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    protected boolean shouldShowName(ItemFrameBlockEntity blockEntity, ItemFrame entity) {
        HitResult hitResult;
        if (Minecraft.renderNames() && !entity.getItem().isEmpty() && entity.getItem().has(DataComponents.CUSTOM_NAME) && (hitResult = this.minecraft.hitResult) != null && hitResult.getType() == HitResult.Type.BLOCK && blockEntity.getBlockPos().equals((Object)((BlockHitResult)hitResult).getBlockPos())) {
            double distanceToEntity = this.minecraft.gameRenderer.getMainCamera().getPosition().distanceToSqr(entity.position());
            double permittedDistance = entity.isDiscrete() ? 32.0 : 64.0;
            return distanceToEntity < permittedDistance * permittedDistance;
        }
        return false;
    }
}

