/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.mixins.structures.PoolElementStructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.mixins.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixins.structures.StructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MonumentPieces;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MonumentStructure
extends Structure {
    public static final MapCodec<MonumentStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MonumentStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("monument_type").forGetter(config -> config.monumentType), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(config -> config.biomeRadius), (App)Codec.INT.optionalFieldOf("fixed_y_spawn").forGetter(config -> config.fixedYSpawn), (App)Codec.FLOAT.optionalFieldOf("center_terrain_height_weight").forGetter(config -> config.centerTerrainHeightWeight), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, MonumentStructure::new));
    public final String monumentType;
    public final Optional<Integer> biomeRadius;
    public final Optional<Integer> fixedYSpawn;
    public final Optional<Float> centerTerrainHeightWeight;
    public final LiquidSettings liquidSettings;

    public MonumentStructure(Structure.StructureSettings config, String monumentType, Optional<Integer> biomeRadius, Optional<Integer> fixedYSpawn, Optional<Float> centerTerrainHeightWeight, LiquidSettings liquidSettings) {
        super(config);
        this.monumentType = monumentType.toLowerCase(Locale.ROOT);
        this.biomeRadius = biomeRadius;
        this.fixedYSpawn = fixedYSpawn;
        this.centerTerrainHeightWeight = centerTerrainHeightWeight;
        this.liquidSettings = liquidSettings;
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.chunkPos();
        if (this.biomeRadius.isPresent() && !(context.biomeSource() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            for (int curChunkX = chunkPos.x - validBiomeRange; curChunkX <= chunkPos.x + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.z - validBiomeRange; curChunkZ <= chunkPos.z + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.biomeSource().getNoiseBiome(QuartPos.fromSection((int)curChunkX), QuartPos.fromBlock((int)blockPos.getY()), QuartPos.fromSection((int)curChunkZ), context.randomState().sampler());
                    if (context.validBiome().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int finalheight;
        ChunkPos chunkPos = context.chunkPos();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        BlockPos centerPoint = chunkPos.getMiddleBlockPosition(0);
        if (this.fixedYSpawn.isPresent()) {
            finalheight = this.fixedYSpawn.get();
        } else {
            int centerHeight;
            float centerWeight = this.centerTerrainHeightWeight.orElse(Float.valueOf(1.0f)).floatValue();
            int highestLandPos = centerHeight = GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), centerPoint.getX(), centerPoint.getZ(), Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) - 1;
            highestLandPos = Math.min(highestLandPos, GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), centerPoint.getX() + 29, centerPoint.getZ() + 29, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) - 1);
            highestLandPos = Math.min(highestLandPos, GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), centerPoint.getX() - 29, centerPoint.getZ() + 29, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) - 1);
            highestLandPos = Math.min(highestLandPos, GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), centerPoint.getX() + 29, centerPoint.getZ() - 29, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) - 1);
            highestLandPos = Math.min(highestLandPos, GeneralUtils.getCachedFreeHeight(context.chunkGenerator(), centerPoint.getX() - 29, centerPoint.getZ() - 29, Heightmap.Types.WORLD_SURFACE_WG, context.heightAccessor(), context.randomState()) - 1);
            finalheight = (int)((float)(highestLandPos - centerHeight) / centerWeight) + centerHeight;
        }
        if (finalheight <= context.chunkGenerator().getMinY()) {
            return Optional.empty();
        }
        if (!this.extraSpawningChecks(context, chunkPos.getMiddleBlockPosition(finalheight))) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(chunkPos.getMiddleBlockPosition(finalheight), structurePiecesBuilder -> {
            List<StructurePiece> list = MonumentPieces.createMonumentBuilding(context.registryAccess(), context.structureTemplateManager(), (RandomSource)random, centerPoint.getX(), finalheight, centerPoint.getZ(), this.monumentType, this.liquidSettings);
            Rotation rotation = Rotation.getRandom((RandomSource)random);
            BlockPos mainOffset = new BlockPos(-29, 0, -29).rotate(rotation);
            for (StructurePiece structurePiece : list) {
                if (!(structurePiece instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece poolPiece = (PoolElementStructurePiece)structurePiece;
                ((PoolElementStructurePieceAccessor)poolPiece).repurposedstructures$setRotation(poolPiece.getRotation().getRotated(rotation));
                BlockPos piecePos = poolPiece.getPosition();
                BlockPos offsetPos = piecePos.subtract((Vec3i)centerPoint);
                BlockPos rotatedOffset = offsetPos.rotate(rotation);
                GeneralUtils.movePieceProperly((StructurePiece)poolPiece, rotatedOffset.getX() - offsetPos.getX(), 0, rotatedOffset.getZ() - offsetPos.getZ());
                GeneralUtils.movePieceProperly((StructurePiece)poolPiece, mainOffset.getX(), 0, mainOffset.getZ());
                StructurePoolElement patt0$temp = poolPiece.getElement();
                if (!(patt0$temp instanceof SinglePoolElement)) continue;
                SinglePoolElement singlePoolElement = (SinglePoolElement)patt0$temp;
                StructureTemplate structuretemplate = ((SinglePoolElementAccessor)singlePoolElement).repurposedstructures$callGetTemplate(context.structureTemplateManager());
                ((StructurePieceAccessor)poolPiece).repurposedstructures$setBoundingBox(structuretemplate.getBoundingBox(new StructurePlaceSettings().setRotation(rotation), poolPiece.getPosition()));
            }
            list.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).addPiece(arg_0));
        }));
    }

    public StructureType<?> type() {
        return RSStructures.MONUMENT_STRUCTURE.get();
    }
}

