/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BottomPillarProcessor
extends StructureProcessor {
    private static final ResourceLocation EMPTY_RL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty");
    public static final MapCodec<BottomPillarProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("pillar_processor_list", (Object)EMPTY_RL).forGetter(processor -> processor.processorList), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)1000).forGetter(config -> config.pillarLength), (App)Codec.BOOL.optionalFieldOf("forced_placement", (Object)false).forGetter(config -> config.forcePlacement)).apply((Applicative)instance, instance.stable(BottomPillarProcessor::new)));
    public final ResourceLocation processorList;
    public final int pillarLength;
    public final boolean forcePlacement;

    private BottomPillarProcessor(ResourceLocation processorList, int pillarLength, boolean forcePlacement) {
        this.processorList = processorList;
        this.pillarLength = pillarLength;
        this.forcePlacement = forcePlacement;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos templateOffset, BlockPos worldOffset, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.state();
        if (structureBlockInfoLocal.pos().getY() == 0) {
            WorldGenRegion worldGenRegion;
            BlockPos worldPos = structureBlockInfoWorld.pos();
            BlockState replacementState = blockState;
            BlockState originalReplacementState = blockState;
            BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
            Optional structureProcessorList = Optional.empty();
            if (this.processorList != null && !this.processorList.equals((Object)EMPTY_RL)) {
                structureProcessorList = levelReader.registryAccess().lookupOrThrow(Registries.PROCESSOR_LIST).get(this.processorList);
            }
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                return structureBlockInfoWorld;
            }
            int terrainY = Integer.MIN_VALUE;
            if (!this.forcePlacement && (terrainY = GeneralUtils.getFirstLandYFromPos(levelReader, worldPos)) <= levelReader.getMinY() && this.pillarLength + 2 >= worldPos.getY() - levelReader.getMinY()) {
                return structureBlockInfoWorld;
            }
            ChunkAccess chunkAccess = levelReader.getChunk(worldPos);
            currentPos.move(Direction.DOWN);
            BlockState currentBlock = chunkAccess.getBlockState((BlockPos)currentPos);
            boolean currentLayer = this.isSpotValidForReplacement(levelReader, currentBlock, currentPos, terrainY, worldPos);
            currentPos.move(Direction.DOWN);
            BlockState secondBottomBlock = chunkAccess.getBlockState((BlockPos)currentPos);
            boolean skipInitialLayer = this.isSpotValidForReplacement(levelReader, secondBottomBlock, currentPos, terrainY, worldPos);
            currentPos.move(Direction.UP);
            while (skipInitialLayer || currentLayer) {
                skipInitialLayer = false;
                StructureTemplate.StructureBlockInfo newPillarState1 = new StructureTemplate.StructureBlockInfo(currentPos.subtract((Vec3i)worldPos).offset((Vec3i)templateOffset), replacementState, null);
                StructureTemplate.StructureBlockInfo newPillarState2 = new StructureTemplate.StructureBlockInfo(currentPos.immutable(), replacementState, null);
                if (structureProcessorList.isPresent()) {
                    for (StructureProcessor processor : ((StructureProcessorList)((Holder.Reference)structureProcessorList.get()).value()).list()) {
                        if (newPillarState2 == null) break;
                        newPillarState2 = processor.processBlock(levelReader, newPillarState1.pos(), newPillarState2.pos(), newPillarState1, newPillarState2, structurePlacementData);
                    }
                }
                if (newPillarState2 != null) {
                    chunkAccess.setBlockState((BlockPos)currentPos, newPillarState2.state(), 2);
                }
                currentPos.move(Direction.DOWN);
                currentBlock = chunkAccess.getBlockState((BlockPos)currentPos);
                currentLayer = this.isSpotValidForReplacement(levelReader, currentBlock, currentPos, terrainY, worldPos);
            }
        }
        return structureBlockInfoWorld;
    }

    private boolean isSpotValidForReplacement(LevelReader levelReader, BlockState currentBlock, BlockPos.MutableBlockPos currentPos, int terrainY, BlockPos worldPos) {
        return (this.forcePlacement && currentBlock.getBlock().defaultDestroyTime() >= 0.0f || !currentBlock.canOcclude()) && !levelReader.isOutsideBuildHeight(currentPos.getY()) && currentPos.closerThan((Vec3i)worldPos, (double)this.pillarLength);
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.BOTTOM_PILLAR_PROCESSOR.get();
    }
}

