/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetChanceConfig;
import java.util.BitSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureBreakage
extends Feature<StructureTargetChanceConfig> {
    private static final Predicate<BlockState> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.is(BlockTags.BASE_STONE_OVERWORLD) || blockState.is(BlockTags.STONE_BRICKS) || blockState.is(BlockTags.DIRT) || blockState.is(Blocks.INFESTED_CHISELED_STONE_BRICKS) || blockState.is(Blocks.INFESTED_CRACKED_STONE_BRICKS) || blockState.is(Blocks.INFESTED_STONE_BRICKS) || blockState.is(Blocks.INFESTED_MOSSY_STONE_BRICKS) || blockState.is(Blocks.IRON_BARS) || blockState.is(Blocks.GRAVEL) || blockState.is(Blocks.SUSPICIOUS_GRAVEL) || blockState.is(BlockTags.FLOWER_POTS);
    };

    public StructureBreakage(Codec<StructureTargetChanceConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetChanceConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (context.random().nextFloat() < ((StructureTargetChanceConfig)context.config()).chance) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(7) - 3, 0, context.random().nextInt(7) - 3);
            boolean foundSurface = this.findSurface(context.level(), mutable, Direction.UP);
            if (!foundSurface) {
                mutable.move(Direction.DOWN, 5);
                foundSurface = this.findSurface(context.level(), mutable, Direction.DOWN);
            }
            if (!foundSurface) {
                return false;
            }
            mutable.move(Direction.UP, 2);
            float f = context.random().nextFloat() * (float)Math.PI;
            float g = 3.0f;
            int i = 2;
            double d = (float)mutable.getX() + Mth.sin((float)f) * g;
            double e = (float)mutable.getX() - Mth.sin((float)f) * g;
            double h = (float)mutable.getZ() + Mth.cos((float)f) * g;
            double j = (float)mutable.getZ() - Mth.cos((float)f) * g;
            double l = mutable.getY() + context.random().nextInt(3) - 2;
            double m = mutable.getY() + context.random().nextInt(3) - 2;
            int n = mutable.getX() - Mth.ceil((float)g) - i;
            int o = mutable.getY() - 4;
            int p = mutable.getZ() - Mth.ceil((float)g) - i;
            int q = 2 * (Mth.ceil((float)g) + i);
            int r = 8;
            for (int s = n; s <= n + q; ++s) {
                int t = p;
                if (t > p + q) continue;
                return this.generateVeinPart(context, d, e, h, j, l, m, n, o, p, q, r, context.chunkGenerator());
            }
        }
        return true;
    }

    private boolean findSurface(WorldGenLevel world, BlockPos.MutableBlockPos mutable, Direction direction) {
        for (int i = 0; i <= 5; ++i) {
            if (FORTRESS_BLOCKS.test(world.getBlockState((BlockPos)mutable))) {
                return true;
            }
            mutable.move(direction);
        }
        return false;
    }

    protected boolean generateVeinPart(FeaturePlaceContext<StructureTargetChanceConfig> context, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int size, int i, ChunkGenerator chunkGenerator) {
        double r;
        double q;
        double p;
        double o;
        int m;
        int j = 0;
        BitSet bitSet = new BitSet(size * i * size);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double[] ds = new double[96];
        for (m = 0; m < 24; ++m) {
            float f = (float)m / 24.0f;
            o = Mth.lerp((double)f, (double)startX, (double)endX);
            p = Mth.lerp((double)f, (double)startY, (double)endY);
            q = Mth.lerp((double)f, (double)startZ, (double)endZ);
            r = context.random().nextDouble() * 24.0 / 16.0;
            double l = ((double)(Mth.sin((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
            ds[m * 4] = o;
            ds[m * 4 + 1] = p;
            ds[m * 4 + 2] = q;
            ds[m * 4 + 3] = l;
        }
        for (m = 0; m < 23; ++m) {
            if (!(ds[m * 4 + 3] > 0.0)) continue;
            for (int n = m + 1; n < 24; ++n) {
                if (!(ds[n * 4 + 3] > 0.0) || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4] - ds[n * 4]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        for (m = 0; m < 24; ++m) {
            double t = ds[m * 4 + 3];
            if (!(t >= 0.0)) continue;
            double u = ds[m * 4];
            double v = ds[m * 4 + 1];
            double w = ds[m * 4 + 2];
            int aa = Math.max(Mth.floor((double)(u - t)), x);
            int ab = Math.max(Mth.floor((double)(v - t)), y);
            int ac = Math.max(Mth.floor((double)(w - t)), z);
            int ad = Math.max(Mth.floor((double)(u + t)), aa);
            int ae = Math.max(Mth.floor((double)(v + t)), ab);
            int af = Math.max(Mth.floor((double)(w + t)), ac);
            for (int ag = aa; ag <= ad; ++ag) {
                double ah = ((double)ag + 0.5 - u) / t;
                if (!(ah * ah < 1.0)) continue;
                for (int ai = ab; ai <= ae; ++ai) {
                    double aj = ((double)ai + 0.5 - v) / t;
                    if (!(ah * ah + aj * aj < 1.0)) continue;
                    for (int ak = ac; ak <= af; ++ak) {
                        boolean isBelowSealevel;
                        int am;
                        double al = ((double)ak + 0.5 - w) / t;
                        if (!(ah * ah + aj * aj + al * al < 1.0) || bitSet.get(am = ag - x + (ai - y) * size + (ak - z) * size * i)) continue;
                        bitSet.set(am);
                        mutable.set(ag, ai, ak);
                        BlockState state = context.level().getBlockState((BlockPos)mutable);
                        if (!FORTRESS_BLOCKS.test(state)) continue;
                        ChunkPos currentChunkPos = new ChunkPos((BlockPos)mutable);
                        ChunkAccess currentChunk = context.level().getChunk(currentChunkPos.x, currentChunkPos.z);
                        boolean bl = isBelowSealevel = mutable.getY() < chunkGenerator.getSeaLevel();
                        if (isBelowSealevel && this.isBorderingAir((ServerLevelAccessor)context.level(), mutable)) continue;
                        currentChunk.setBlockState((BlockPos)mutable, isBelowSealevel ? Blocks.WATER.defaultBlockState() : Blocks.CAVE_AIR.defaultBlockState(), 2);
                        ++j;
                        state = currentChunk.getBlockState((BlockPos)mutable.move(Direction.DOWN));
                        while (mutable.getY() > currentChunk.getMinY() && mutable.getY() < currentChunk.getMaxY() && (state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(BlockTags.FLOWERS))) {
                            currentChunk.setBlockState((BlockPos)mutable, isBelowSealevel ? Blocks.WATER.defaultBlockState() : Blocks.CAVE_AIR.defaultBlockState(), 2);
                            state = currentChunk.getBlockState((BlockPos)mutable.move(Direction.DOWN));
                        }
                        state = currentChunk.getBlockState((BlockPos)mutable.move(Direction.UP));
                        boolean bl2 = isBelowSealevel = mutable.getY() < chunkGenerator.getSeaLevel();
                        if (state.is(BlockTags.FLOWER_POTS)) {
                            currentChunk.setBlockState((BlockPos)mutable, isBelowSealevel ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 2);
                        } else {
                            while (mutable.getY() > currentChunk.getMinY() && mutable.getY() < currentChunk.getMaxY() && (state.is(BlockTags.REPLACEABLE_BY_TREES) || state.is(BlockTags.FLOWERS))) {
                                currentChunk.setBlockState((BlockPos)mutable, isBelowSealevel ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 2);
                                state = currentChunk.getBlockState((BlockPos)mutable.move(Direction.UP));
                            }
                        }
                        BlockPos.MutableBlockPos mutableVineCheck = new BlockPos.MutableBlockPos();
                        for (Direction direction : Direction.values()) {
                            BlockState neighboringBlock;
                            if (direction == Direction.UP) continue;
                            mutableVineCheck.set((Vec3i)mutable).move(direction);
                            if (currentChunkPos.x != mutableVineCheck.getX() >> 4 || currentChunkPos.z != mutableVineCheck.getZ() >> 4) {
                                currentChunk = context.level().getChunk((BlockPos)mutableVineCheck);
                                currentChunkPos = new ChunkPos((BlockPos)mutableVineCheck);
                            }
                            if (!(neighboringBlock = currentChunk.getBlockState((BlockPos)mutableVineCheck)).is(Blocks.VINE) || !((Boolean)neighboringBlock.getValue((Property)VineBlock.getPropertyForFace((Direction)direction.getOpposite()))).booleanValue()) continue;
                            while (mutable.getY() > currentChunk.getMinY() && mutable.getY() < currentChunk.getMaxY() && (neighboringBlock.is(BlockTags.REPLACEABLE_BY_TREES) || neighboringBlock.is(BlockTags.FLOWERS))) {
                                currentChunk.setBlockState((BlockPos)mutableVineCheck, isBelowSealevel ? Blocks.WATER.defaultBlockState() : Blocks.CAVE_AIR.defaultBlockState(), 2);
                                neighboringBlock = currentChunk.getBlockState((BlockPos)mutableVineCheck.move(Direction.DOWN));
                            }
                        }
                    }
                }
            }
        }
        return j > 0;
    }

    private boolean isBorderingAir(ServerLevelAccessor world, BlockPos.MutableBlockPos mutable) {
        BlockPos.MutableBlockPos mutableWaterCheck = new BlockPos.MutableBlockPos();
        ChunkPos currentChunkPos2 = new ChunkPos((BlockPos)mutable);
        ChunkAccess currentChunk2 = world.getChunk(currentChunkPos2.x, currentChunkPos2.z);
        for (Direction direction : Direction.values()) {
            if (direction == Direction.UP) continue;
            mutableWaterCheck.set((Vec3i)mutable).move(direction);
            if (currentChunkPos2.x != mutableWaterCheck.getX() >> 4 || currentChunkPos2.z != mutableWaterCheck.getZ() >> 4) {
                currentChunk2 = world.getChunk((BlockPos)mutableWaterCheck);
                currentChunkPos2 = new ChunkPos((BlockPos)mutableWaterCheck);
            }
            if (!currentChunk2.getBlockState((BlockPos)mutableWaterCheck).isAir()) continue;
            return true;
        }
        return false;
    }
}

