/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DrownedWithArmor
extends Feature<NoneFeatureConfiguration> {
    public DrownedWithArmor() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        if (!context.level().getBlockState(context.origin()).getFluidState().is(FluidTags.WATER)) {
            return false;
        }
        BlockPos position = context.origin().below();
        Drowned drownedEntity = (Drowned)EntityType.DROWNED.create((Level)context.level().getLevel(), EntitySpawnReason.STRUCTURE);
        if (drownedEntity == null) {
            return false;
        }
        if (context.random().nextFloat() < 0.45f) {
            ItemStack stoneSword = new ItemStack((ItemLike)Items.STONE_SWORD);
            drownedEntity.setItemInHand(InteractionHand.MAIN_HAND, GeneralUtils.enchantRandomly(context.level().registryAccess(), context.random(), stoneSword, 0.25f));
            drownedEntity.setDropChance(EquipmentSlot.MAINHAND, 0.4f);
            drownedEntity.setLeftHanded(context.random().nextFloat() < 0.05f);
        }
        if (context.level().getRandom().nextFloat() < 0.4f) {
            drownedEntity.setItemSlot(EquipmentSlot.HEAD, context.level().getRandom().nextFloat() < 0.2f ? Items.IRON_HELMET.getDefaultInstance() : Items.CHAINMAIL_HELMET.getDefaultInstance());
        }
        if (context.level().getRandom().nextFloat() < 0.4f) {
            drownedEntity.setItemSlot(EquipmentSlot.CHEST, context.level().getRandom().nextFloat() < 0.2f ? Items.IRON_CHESTPLATE.getDefaultInstance() : Items.CHAINMAIL_CHESTPLATE.getDefaultInstance());
        }
        if (context.level().getRandom().nextFloat() < 0.4f) {
            drownedEntity.setItemSlot(EquipmentSlot.LEGS, context.level().getRandom().nextFloat() < 0.2f ? Items.IRON_LEGGINGS.getDefaultInstance() : Items.CHAINMAIL_LEGGINGS.getDefaultInstance());
        }
        if (context.level().getRandom().nextFloat() < 0.4f) {
            drownedEntity.setItemSlot(EquipmentSlot.FEET, context.level().getRandom().nextFloat() < 0.2f ? Items.IRON_BOOTS.getDefaultInstance() : Items.CHAINMAIL_BOOTS.getDefaultInstance());
        }
        drownedEntity.setPersistenceRequired();
        drownedEntity.setPos((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5);
        drownedEntity.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(position), EntitySpawnReason.STRUCTURE, null);
        context.level().addFreshEntityWithPassengers((Entity)drownedEntity);
        return true;
    }
}

