/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;

public class BoxOctree {
    private static final int subdivideThreshold = 10;
    private static final int maximumDepth = 3;
    private final AABB boundary;
    private final Vec3i size;
    private final int depth;
    private final List<AABB> innerBoxes = new ArrayList<AABB>();
    private final List<BoxOctree> childrenOctants = new ArrayList<BoxOctree>();

    public BoxOctree(AABB axisAlignedBB) {
        this(axisAlignedBB, 0);
    }

    private BoxOctree(AABB axisAlignedBB, int parentDepth) {
        this.boundary = axisAlignedBB.move(0.0, 0.0, 0.0);
        this.size = new Vec3i(this.roundAwayFromZero(this.boundary.getXsize()), this.roundAwayFromZero(this.boundary.getYsize()), this.roundAwayFromZero(this.boundary.getZsize()));
        this.depth = parentDepth + 1;
    }

    private int roundAwayFromZero(double value) {
        return value >= 0.0 ? (int)Math.ceil(value) : (int)Math.floor(value);
    }

    private void subdivide() {
        if (!this.childrenOctants.isEmpty()) {
            throw new UnsupportedOperationException("repurposed_structures - Tried to subdivide when there are already children octants.");
        }
        int halfXSize = this.size.getX() / 2;
        int halfYSize = this.size.getY() / 2;
        int halfZSize = this.size.getZ() / 2;
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX, this.boundary.minY, this.boundary.minZ, this.boundary.minX + (double)halfXSize, this.boundary.minY + (double)halfYSize, this.boundary.minZ + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX, this.boundary.minY, this.boundary.minZ + (double)halfZSize, this.boundary.minX + (double)halfXSize, this.boundary.minY + (double)halfYSize, this.boundary.maxZ), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX + (double)halfXSize, this.boundary.minY, this.boundary.minZ, this.boundary.maxX, this.boundary.minY + (double)halfYSize, this.boundary.minZ + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX + (double)halfXSize, this.boundary.minY, this.boundary.minZ + (double)halfZSize, this.boundary.maxX, this.boundary.minY + (double)halfYSize, this.boundary.maxZ), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX, this.boundary.minY + (double)halfYSize, this.boundary.minZ, this.boundary.minX + (double)halfXSize, this.boundary.maxY, this.boundary.minZ + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX, this.boundary.minY + (double)halfYSize, this.boundary.minZ + (double)halfZSize, this.boundary.minX + (double)halfXSize, this.boundary.maxY, this.boundary.maxZ), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX + (double)halfXSize, this.boundary.minY + (double)halfYSize, this.boundary.minZ, this.boundary.maxX, this.boundary.maxY, this.boundary.minZ + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new AABB(this.boundary.minX + (double)halfXSize, this.boundary.minY + (double)halfYSize, this.boundary.minZ + (double)halfZSize, this.boundary.maxX, this.boundary.maxY, this.boundary.maxZ), this.depth));
        for (AABB parentInnerBox : this.innerBoxes) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryIntersects(parentInnerBox)) continue;
                octree.addBox(parentInnerBox);
            }
        }
        this.innerBoxes.clear();
    }

    public void addBox(AABB axisAlignedBB) {
        if (this.depth < 3 && this.innerBoxes.size() > 10) {
            this.subdivide();
        }
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryIntersects(axisAlignedBB)) continue;
                octree.addBox(axisAlignedBB);
            }
        } else {
            for (AABB parentInnerBox : this.innerBoxes) {
                if (!parentInnerBox.equals((Object)axisAlignedBB)) continue;
                return;
            }
            this.innerBoxes.add(axisAlignedBB);
        }
    }

    public boolean boundaryEntirelyContains(AABB axisAlignedBB) {
        return this.boundary.contains(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ) && this.boundary.contains(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ);
    }

    public boolean boundaryIntersects(AABB axisAlignedBB) {
        return this.boundary.intersects(axisAlignedBB);
    }

    public boolean withinBoundsButNotIntersectingChildren(AABB axisAlignedBB) {
        return this.boundaryEntirelyContains(axisAlignedBB) && !this.intersectsAnyBox(axisAlignedBB);
    }

    public boolean intersectsAnyBox(AABB axisAlignedBB) {
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryIntersects(axisAlignedBB) || !octree.intersectsAnyBox(axisAlignedBB)) continue;
                return true;
            }
        } else {
            for (AABB innerBox : this.innerBoxes) {
                if (!innerBox.intersects(axisAlignedBB)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean boundaryContains(BlockPos position) {
        return this.boundary.contains((double)position.getX(), (double)position.getY(), (double)position.getZ());
    }

    public boolean withinAnyBox(BlockPos position) {
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryContains(position) || !octree.withinAnyBox(position)) continue;
                return true;
            }
        } else {
            for (AABB innerBox : this.innerBoxes) {
                if (!innerBox.contains((double)position.getX(), (double)position.getY(), (double)position.getZ())) continue;
                return true;
            }
        }
        return false;
    }
}

